---
generated_at: 2025-12-26 18:53:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：259-購買契約一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：実際のルーティング設定での確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource/Pages/ListPurchaseAgreements.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource.php`
- E-03: `plugins/webkul/purchases/src/Models/Requisition.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListPurchaseAgreementsはListRecordsを継承 | E-01 | ○ |
| C-02 | 新規作成ボタンが存在 | E-01 (getHeaderActions) | ○ |
| C-03 | プリセットビューが6種類存在 | E-01 (getPresetTableViews) | ○ |
| C-04 | my_agreements（マイ契約）ビュー存在 | E-01 | ○ |
| C-05 | blanket_orders（包括発注）ビュー存在 | E-01 | ○ |
| C-06 | purchase_templates（購買テンプレート）ビュー存在 | E-01 | ○ |
| C-07 | draft（下書き）ビュー存在 | E-01 | ○ |
| C-08 | done（完了）ビュー存在 | E-01 | ○ |
| C-09 | archived（アーカイブ）ビュー存在 | E-01 (onlyTrashed) | ○ |
| C-10 | テーブルカラムにname存在 | E-02 (table columns) | ○ |
| C-11 | テーブルカラムにpartner.name存在 | E-02 | ○ |
| C-12 | テーブルカラムにtype存在 | E-02 | ○ |
| C-13 | 削除アクション存在 | E-02 (DeleteAction) | ○ |
| C-14 | 復元アクション存在 | E-02 (RestoreAction) | ○ |
| C-15 | 完全削除アクション存在 | E-02 (ForceDeleteAction) | ○ |
| C-16 | ソフトデリート使用 | E-03 (SoftDeletes) | ○ |
| C-17 | 契約番号BO/XXX形式 | E-03 (updateName) | ○ |
| C-18 | 契約番号PT/XXX形式 | E-03 (updateName) | ○ |
| C-19 | Requisitionモデルを使用 | E-02 ($model) | ○ |
| C-20 | purchases_requisitionsテーブル | E-03 ($table) | ○ |
| C-21 | OrderSettingsで有効/無効制御 | E-02 (isDiscovered) | ○ |
| C-22 | CLOSED状態は削除不可 | E-02 (DeleteAction hidden) | ○ |
| C-23 | URLパターン /purchase-agreements | E-02 (getPages) | △ |
| C-24 | ID降順で取得 | E-02 (getEloquentQuery) | ○ |

## 4) 不足情報（Unknown / Missing）

- 実際のルーティング設定ファイルでのURL確認
  - 候補：routes/web.php / Filament Panel Provider

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 一覧表示機能は十分に根拠あり
- 0: 低リスク - プリセットビュー・フィルター機能は実装確認済み
- 0: 低リスク - ソフトデリート機能は明確に実装されている

## 6) レビュアーチェックリスト（最小）

- [ ] 実環境でURLパスが正しいか確認
- [ ] enable_purchase_agreements設定が無効時に画面が非表示になるか確認
- [ ] 各プリセットビューの絞り込み条件が正しいか確認
- [ ] アーカイブ・復元・完全削除が正しく動作するか確認
- [ ] CLOSED状態の契約が削除不可であることを確認
- [ ] 契約番号のフォーマット（BO/PT）が正しいか確認
