---
generated_at: 2025-12-26 12:25:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：26-請求書作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **権限による表示制御**：権限設定の詳細実装未確認
  2. **Account::computeAccountMove処理内容**：Facadeの実装詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Pages/CreateInvoice.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行27）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がCreateRecord | E-01: CreateRecord継承 | ○ |
| C-02 | HasRepeaterColumnManagerトレイトを使用 | E-01: use HasRepeaterColumnManager | ○ |
| C-03 | 保存後に詳細画面へリダイレクト | E-01: getRedirectUrl() | ○ |
| C-04 | 作成成功時に通知を表示 | E-01: getCreatedNotification() | ○ |
| C-05 | mutateFormDataBeforeCreateでmove_type設定 | E-01: mutateFormDataBeforeCreate() | ○ |
| C-06 | mutateFormDataBeforeCreateでdate設定 | E-01: $data['date'] = now() | ○ |
| C-07 | afterCreateでcomputeAccountMove実行 | E-01: afterCreate() | ○ |
| C-08 | ProgressStepperでステータス表示 | E-02: ProgressStepper::make('state') | ○ |
| C-09 | 顧客選択でサブタイプcustomerのみ | E-02: where('sub_type', 'customer') | ○ |
| C-10 | 顧客選択時に関連項目を自動設定 | E-02: afterStateUpdated partner_id | ○ |
| C-11 | 請求明細リピーターがある | E-02: getProductRepeater() | ○ |
| C-12 | リピーターがテーブルレイアウト | E-02: table([...]) | ○ |
| C-13 | 商品選択時に価格・税を自動設定 | E-02: afterProductUpdated() | ○ |
| C-14 | 数量変更時に小計を再計算 | E-02: afterProductQtyUpdated() | ○ |
| C-15 | UOM変更時に単価を再計算 | E-02: afterUOMUpdated() | ○ |
| C-16 | 税・割引・単価変更時に小計再計算 | E-02: calculateLineTotals() | ○ |
| C-17 | 会社変更時に通貨を更新 | E-02: company_id afterStateUpdated | ○ |
| C-18 | InvoiceSummary Livewireコンポーネント使用 | E-02: Livewire::make(InvoiceSummary::class) | ○ |
| C-19 | 削除済みデータを選択肢に表示 | E-02: withTrashed各所 | ○ |
| C-20 | 削除済みデータは選択不可 | E-02: disableOptionWhen (Deleted) | ○ |
| C-21 | 同一商品の重複選択を防止 | E-02: disableOptionWhen 重複チェック | ○ |
| C-22 | UOM機能は設定で切り替え可能 | E-02: visible ProductSettings enable_uom | ○ |
| C-23 | 3つのタブ構成 | E-02: Tabs invoice-lines, other-information, terms | ○ |
| C-24 | その他情報に4つのフィールドセット | E-02: Fieldset invoice, accounting, additional, marketing | ○ |
| C-25 | 明細にcurrency_idを親から設定 | E-02: mutateProductRelationship | ○ |
| C-26 | 税は販売税（SALE）のみ | E-02: TypeTaxUse::SALE | ○ |
| C-27 | 画面一覧に登録されている | E-03: No.26 請求書作成 | ○ |
| C-28 | ルーティングが/create | E-02: getPages() 'create' route | ○ |
| C-29 | 権限による表示制御の詳細 | **根拠なし** | △ |
| C-30 | computeAccountMoveの処理内容 | **根拠なし（Facade実装）** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限設定の詳細はFilamentの権限設定またはポリシークラスの確認が必要
  - 候補：`MovePolicy.php` / `Filament Shield設定`
- Account Facadeの実装詳細
  - 候補：`plugins/webkul/accounts/src/Facades/Account.php` および実装クラス
- account_moves, account_move_linesテーブルのマイグレーション定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム項目定義（ソースコードから明確）
- 0: 低リスク - リピーター動作（ソースコードから明確）
- 0: 低リスク - 自動計算ロジック（ソースコードから明確）
- 1: 中リスク - 権限制御の詳細（別ファイル参照必要）
- 1: 中リスク - 仕訳計算の詳細（Facade実装参照必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限設定の実装内容を確認
- [ ] Account::computeAccountMoveの処理内容を確認
- [ ] 多言語ファイル（accounts::filament/resources/invoice/pages/create-invoice）の存在確認
- [ ] account_moves, account_move_linesテーブルのマイグレーション定義との整合性確認
- [ ] ProductSettings設定の確認
