---
generated_at: 2025-12-26 18:56:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：260-購買契約作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **仕入先デフォルト通貨の自動設定**：実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource/Pages/CreatePurchaseAgreement.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource.php`
- E-03: `plugins/webkul/purchases/src/Models/Requisition.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreatePurchaseAgreementはCreateRecordを継承 | E-01 | ○ |
| C-02 | formメソッドで入力項目定義 | E-02 (form method) | ○ |
| C-03 | 仕入先選択でsub_type=supplierフィルタ | E-02 | ○ |
| C-04 | 契約タイプにBLANKET_ORDER/PURCHASE_TEMPLATE | E-02 (RequisitionType) | ○ |
| C-05 | 通貨選択必須 | E-02 (currency_id required) | ○ |
| C-06 | 有効期間は包括発注時のみ表示 | E-02 (hidden condition) | ○ |
| C-07 | 開始日変更で終了日クリア | E-02 (afterStateUpdated) | ○ |
| C-08 | 終了日の最小日付は開始日 | E-02 (minDate get starts_at) | ○ |
| C-09 | 会社はデフォルト会社が初期値 | E-02 (default company_id) | ○ |
| C-10 | 初期stateはDRAFT | E-01 (mutateFormDataBeforeCreate) | ○ |
| C-11 | creator_idは自動設定 | E-01 (mutateFormDataBeforeCreate) | ○ |
| C-12 | 保存後は編集画面に遷移 | E-01 (getRedirectUrl) | ○ |
| C-13 | 進捗ステッパーで状態表示 | E-02 (ProgressStepper) | ○ |
| C-14 | タブ構成で商品/追加/備考 | E-02 (Tabs) | ○ |
| C-15 | 明細はRepeaterで入力 | E-02 (getProductsRepeater) | ○ |
| C-16 | 商品選択で単位自動設定 | E-02 (afterStateUpdated uom_id) | ○ |
| C-17 | 商品は重複選択不可 | E-02 (distinct) | ○ |
| C-18 | 削除済み仕入先は選択不可表示 | E-02 (withTrashed, Deleted表示) | ○ |
| C-19 | 商品はtype=GOODSのみ | E-02 (ProductType::GOODS) | ○ |
| C-20 | is_configurable=nullのみ | E-02 (whereNull is_configurable) | ○ |
| C-21 | 成功通知のメッセージ表示 | E-01 (getCreatedNotification) | ○ |
| C-22 | URLパターン /purchase-agreements/create | E-02 (getPages) | ○ |
| C-23 | RichEditorで備考入力 | E-02 (RichEditor description) | ○ |
| C-24 | 仕入先デフォルト通貨自動設定 | **根拠不足** | △ |
| C-25 | 契約番号自動生成BO/PT形式 | E-03 (updateName) | ○ |
| C-26 | 単位は設定により表示/非表示 | E-02 (enable_uom) | ○ |

## 4) 不足情報（Unknown / Missing）

- 仕入先のデフォルト通貨自動設定の実装詳細
  - 候補：partner選択時のafterStateUpdatedまたは関連ロジック

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - フォーム構成・項目定義は十分に根拠あり
- 0: 低リスク - 契約タイプによる表示制御は明確に実装
- 0: 低リスク - データベース項目は明確に定義されている

## 6) レビュアーチェックリスト（最小）

- [ ] 契約タイプ変更時の有効期間表示制御が正しいか確認
- [ ] 開始日変更時の終了日クリアが正しく動作するか確認
- [ ] 商品選択時の単位自動設定が正しく動作するか確認
- [ ] 作成後のリダイレクト先が編集画面であることを確認
- [ ] 契約番号の自動生成（BO/PT形式）が正しいか確認
- [ ] 削除済み仕入先・商品が選択不可表示されるか確認
