---
generated_at: 2025-12-26 17:00:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：261-購買契約編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **メッセージ仕様**：翻訳ファイル未確認のため実際のメッセージ内容要確認
  2. **PDF出力テンプレート**：テンプレートファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource/Pages/EditPurchaseAgreement.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource.php`
- E-03: `plugins/webkul/purchases/src/Models/Requisition.php`
- E-04: `plugins/webkul/purchases/src/Enums/RequisitionState.php`（参照のみ）
- E-05: `plugins/webkul/purchases/src/Enums/RequisitionType.php`（参照のみ）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はEditRecordを継承している | E-01 L17 | ○ |
| C-02 | Chatterアクションが実装されている | E-01 L40-41 | ○ |
| C-03 | 確認ボタンでDRAFT→CONFIRMED遷移 | E-01 L42-52 | ○ |
| C-04 | クローズボタンでCONFIRMED→CLOSED遷移 | E-01 L53-63 | ○ |
| C-05 | キャンセルボタンでCANCELED遷移 | E-01 L64-77 | ○ |
| C-06 | PDF印刷機能が実装されている | E-01 L78-92 | ○ |
| C-07 | 削除アクションはCLOSEDで非表示 | E-01 L93-94 | ○ |
| C-08 | フォームにProgressStepperがある | E-02 L100-105 | ○ |
| C-09 | 仕入先フィールドはsupplierタイプのみ | E-02 L110-124 | ○ |
| C-10 | 契約タイプはBLANKET_ORDERがデフォルト | E-02 L131-137 | ○ |
| C-11 | 有効期間はBLANKET_ORDER時のみ表示 | E-02 L173-176 | ○ |
| C-12 | 商品明細はRepeaterで実装 | E-02 L220-325 | ○ |
| C-13 | 商品選択で重複不可 | E-02 L263-287 | ○ |
| C-14 | 商品選択で自動的にUOMを設定 | E-02 L288-293 | ○ |
| C-15 | DRAFTステータス以外で一部フィールド無効 | E-02 L124, L130, L136, L194 | ○ |
| C-16 | CLOSED/CANCELEDで商品明細無効 | E-02 L294, L302, L314, L322 | ○ |
| C-17 | テーブル名はpurchases_requisitions | E-03 L30 | ○ |
| C-18 | SoftDeletesが使用されている | E-03 L23 | ○ |
| C-19 | 契約名は自動生成（BO/PT + ID） | E-03 L126-133 | ○ |
| C-20 | リレーション：partner, currency, user, company | E-03 L77-100 | ○ |
| C-21 | リレーション：lines（HasMany） | E-03 L102-105 | ○ |
| C-22 | URL形式は/{record}/edit | E-02 L685 | ○ |
| C-23 | クラスターはOrdersに属する | E-02 L76 | ○ |
| C-24 | ナビゲーションソート順は3 | E-02 L78 | ○ |
| C-25 | HasCustomFieldsトレイト使用 | E-02 L68, E-03 L23 | ○ |
| C-26 | HasChatterトレイト使用 | E-03 L23 | ○ |
| C-27 | サブナビゲーションにView, Editがある | E-02 L672-678 | ○ |
| C-28 | enable_purchase_agreementsで機能ON/OFF | E-02 L87-94 | ○ |
| C-29 | enable_uomでUOMフィールド表示切替 | E-02 L224, L244, L313 | ○ |
| C-30 | カスタムフィールドタブは設定時のみ表示 | E-02 L206-208 | ○ |
| C-31 | PDF出力テンプレートパス | E-01 L83 | △ |
| C-32 | 成功通知のメッセージ内容 | E-01 L29-35 | △ |

## 4) 不足情報（Unknown / Missing）
- PDF出力テンプレートファイル（purchases::filament.admin.clusters.orders.purchase-agreements.print）の実在確認が必要
  - 候補：resources/views/filament/admin/clusters/orders/purchase-agreements/print.blade.php
- 翻訳ファイル（purchases::filament/admin/clusters/orders/resources/purchase-agreement/...）の内容確認
  - 候補：lang/ja/filament/.../purchase-agreement.php

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構成・機能
- 0: 低リスク - ステータス遷移ロジック
- 1: 中リスク - PDF出力機能（テンプレート未確認）
- 0: 低リスク - データベース操作

## 6) レビュアーチェックリスト（最小）
- [ ] PDF出力テンプレートの存在確認
- [ ] 翻訳ファイルのメッセージ内容確認
- [ ] ステータス遷移のビジネスルール妥当性確認
- [ ] 権限制御の実装確認（HasPageShield等）
