---
generated_at: 2025-12-26 17:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：262-購買契約詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **削除時の通知メッセージ**：翻訳キーが別モジュール（inventories）を参照しているため確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource/Pages/ViewPurchaseAgreement.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseAgreementResource.php`
- E-03: `plugins/webkul/purchases/src/Models/Requisition.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はViewRecordを継承している | E-01 L7, L13 | ○ |
| C-02 | Chatterアクションが実装されている | E-01 L22-23 | ○ |
| C-03 | 削除アクションはCLOSEDで非表示 | E-01 L24-25 | ○ |
| C-04 | HasRecordNavigationTabsトレイト使用 | E-01 L15 | ○ |
| C-05 | infolistにステータスバッジがある | E-02 L537-542 | ○ |
| C-06 | 基本情報セクションにアイコン付き項目がある | E-02 L544-591 | ○ |
| C-07 | 仕入先にbuilding-storefrontアイコン | E-02 L551-552 | ○ |
| C-08 | 購入担当者にuserアイコン | E-02 L554-556 | ○ |
| C-09 | 契約タイプはバッジ表示 | E-02 L558-561 | ○ |
| C-10 | 通貨にcurrency-dollarアイコン | E-02 L563-565 | ○ |
| C-11 | 有効期間はBLANKET_ORDERのみ表示 | E-02 L581 | ○ |
| C-12 | 商品明細はRepeatableEntryで表示 | E-02 L599-621 | ○ |
| C-13 | 単価は通貨コード付きで表示 | E-02 L616 | ○ |
| C-14 | UOMフィールドは設定で表示切替 | E-02 L614 | ○ |
| C-15 | 契約条件はMarkdown/Prose表示 | E-02 L631-634 | ○ |
| C-16 | メタデータセクションに作成日時/作成者/更新日時 | E-02 L638-656 | ○ |
| C-17 | URL形式は/{record}/view | E-02 L687 | ○ |
| C-18 | サブナビゲーションにView, Editがある | E-02 L672-678 | ○ |
| C-19 | カスタムフィールドタブは設定時のみ表示 | E-02 L624-626 | ○ |
| C-20 | 追加タブはSectionで実装 | E-02 L624 | ○ |
| C-21 | 条件タブにdocument-textアイコン | E-02 L628-629 | ○ |
| C-22 | メタデータセクションにinformation-circleアイコン | E-02 L639 | ○ |
| C-23 | 商品タブにcubeアイコン | E-02 L596-597 | ○ |
| C-24 | 削除通知はinventoriesモジュールを参照 | E-01 L29-30 | △ |

## 4) 不足情報（Unknown / Missing）
- 削除時の通知メッセージが`inventories::filament/clusters/orders/resources/purchase-agreement/...`を参照している
  - 候補：`purchases::filament/...`が正しい可能性あり（コピペミスの可能性）
  - 確認が必要：翻訳ファイルの実在確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な詳細表示機能
- 0: 低リスク - 画面構成・レイアウト
- 1: 中リスク - 削除通知の翻訳キー誤り可能性
- 0: 低リスク - サブナビゲーション

## 6) レビュアーチェックリスト（最小）
- [ ] 削除通知の翻訳キー（inventories→purchases）の確認
- [ ] 実際の画面表示での項目配置確認
- [ ] カスタムフィールドタブの動作確認
