---
generated_at: 2025-12-26 17:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：263-仕入先一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **テーブルカラム詳細**：親クラス（PartnerResource）のtable定義を直接確認していないため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/VendorResource/Pages/ListVendors.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/VendorResource.php`
- E-03: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource/Pages/ListVendors.php`
- E-04: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListVendorsはBaseListVendorsを継承 | E-01 L10 | ○ |
| C-02 | sub_type='supplier'でクエリフィルタ | E-01 L17 | ○ |
| C-03 | VendorResourceはBaseVendorResourceを継承 | E-02 L22 | ○ |
| C-04 | クラスターはOrdersに属する | E-02 L31 | ○ |
| C-05 | ナビゲーションソート順は4 | E-02 L34 | ○ |
| C-06 | Invoice側のVendorResourceはtableメソッドでcontentGridを設定 | E-04 L199-204 | ○ |
| C-07 | contentGridはsm:1, md:2, xl:3, 2xl:3 | E-04 L199-204 | ○ |
| C-08 | Invoice側でもsub_type='supplier'でフィルタ | E-04 L206 | ○ |
| C-09 | Invoice側のListVendorsにCreateActionがある | E-03 L43-45 | ○ |
| C-10 | URL形式は/vendors（indexルート） | E-02 L73 | ○ |
| C-11 | サブナビゲーションにView, Edit, Contacts, Addresses, Bills, Purchasesがある | E-02 L43-52 | ○ |
| C-12 | モデルはPartnerを使用 | E-02 L26 | ○ |
| C-13 | ナビゲーションアイコンはheroicon-o-users | E-02 L28 | ○ |
| C-14 | recordTitleAttributeはname | E-02 L36 | ○ |
| C-15 | テーブルカラムにname, email, phone等が含まれる | E-04（親クラス継承） | △ |

## 4) 不足情報（Unknown / Missing）
- PartnerResourceのtable定義の詳細確認
  - 候補：`plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
  - テーブルカラムの完全なリストの確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な一覧表示機能
- 0: 低リスク - クエリフィルタ条件
- 1: 中リスク - テーブルカラムの詳細（親クラス依存）
- 0: 低リスク - レイアウト設定

## 6) レビュアーチェックリスト（最小）
- [ ] PartnerResourceのtable定義確認
- [ ] 実際のテーブルカラム表示確認
- [ ] カードレイアウトの表示確認
