---
generated_at: 2025-12-26 17:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：264-仕入先作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **基本情報フィールド**：親クラス（PartnerResource）のform定義の完全確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/VendorResource/Pages/CreateVendor.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/VendorResource.php`
- E-03: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource/Pages/CreateVendor.php`
- E-04: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateVendorはBaseCreateVendorを継承 | E-01 L8 | ○ |
| C-02 | 作成後は詳細画面（view）へリダイレクト | E-03 L14-15 | ○ |
| C-03 | mutateFormDataBeforeCreateでsub_type='supplier'を設定 | E-03 L18-22 | ○ |
| C-04 | Invoice側のformにHiddenでsub_type設定 | E-04 L78-79 | ○ |
| C-05 | 担当者フィールドが存在 | E-04 L80-84 | ○ |
| C-06 | 販売支払条件フィールドが存在 | E-04 L85-89 | ○ |
| C-07 | 入金支払方法フィールドが存在 | E-04 L90-94 | ○ |
| C-08 | 購買支払条件フィールドが存在 | E-04 L103-107 | ○ |
| C-09 | 出金支払方法フィールドが存在 | E-04 L108-112 | ○ |
| C-10 | 財務ポジションフィールドが存在 | E-04 L121-125 | ○ |
| C-11 | 請求送付方法フィールドが存在 | E-04 L142-145 | ○ |
| C-12 | EDI形式フィールドが存在 | E-04 L146-149 | ○ |
| C-13 | PEPPOLフィールドはEDI形式に応じて表示切替 | E-04 L150-161 | ○ |
| C-14 | 自動転記設定フィールドが存在 | E-04 L166-168 | ○ |
| C-15 | 異常金額無視Toggleが存在 | E-04 L169-171 | ○ |
| C-16 | 異常日付無視Toggleが存在 | E-04 L172-175 | ○ |
| C-17 | 内部メモタブにRichEditorが存在 | E-04 L182-183 | ○ |
| C-18 | URL形式は/create | E-02 L74 | ○ |
| C-19 | モデルはPartner | E-02 L26 | ○ |
| C-20 | 基本情報フィールド（name, email等）が存在 | 親クラス（PartnerResource）依存 | △ |

## 4) 不足情報（Unknown / Missing）
- PartnerResourceのform定義の詳細確認
  - 候補：`plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
  - 基本情報フィールドの完全なリストの確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - sub_type自動設定
- 0: 低リスク - リダイレクト先
- 0: 低リスク - 請求関連フィールド
- 1: 中リスク - 基本情報フィールド（親クラス依存）

## 6) レビュアーチェックリスト（最小）
- [ ] PartnerResourceのform定義確認
- [ ] 基本情報フィールドの完全なリスト確認
- [ ] 作成後のリダイレクト動作確認
