---
generated_at: 2025-12-26 17:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：266-仕入先詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **基本情報フィールド**：親クラス（PartnerResource）のinfolist定義の完全確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/VendorResource/Pages/ViewVendor.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/VendorResource.php`
- E-03: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource/Pages/ViewVendor.php`
- E-04: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewVendorはBaseViewPartnerを継承 | E-03 L9 | ○ |
| C-02 | URL形式は/{record}（viewルート） | E-02 L75 | ○ |
| C-03 | サブナビゲーションにView, Edit, Contacts, Addresses, Bills, Purchasesがある | E-02 L43-52 | ○ |
| C-04 | infolistに担当者表示がある（userアイコン付き） | E-04 L237-240 | ○ |
| C-05 | infolistに販売支払条件表示がある（calendarアイコン付き） | E-04 L241-244 | ○ |
| C-06 | infolistに入金支払方法表示がある（credit-cardアイコン付き） | E-04 L245-248 | ○ |
| C-07 | 購買フィールドセットに購買支払条件がある（calendarアイコン付き） | E-04 L257-260 | ○ |
| C-08 | 購買フィールドセットに出金支払方法がある（banknotesアイコン付き） | E-04 L261-264 | ○ |
| C-09 | 財務情報フィールドセットに財務ポジションがある（document-textアイコン付き） | E-04 L273-276 | ○ |
| C-10 | 請求タブに請求送付方法がある（paper-airplaneアイコン付き） | E-04 L293-296 | ○ |
| C-11 | 請求タブにEDI形式がある（documentアイコン付き） | E-04 L297-300 | ○ |
| C-12 | 請求タブにPEPPOL EASがある（identificationアイコン付き） | E-04 L303-306 | ○ |
| C-13 | 請求タブにエンドポイントがある（globe-altアイコン付き） | E-04 L307-310 | ○ |
| C-14 | 自動化フィールドセットに自動転記表示がある（boltアイコン付き） | E-04 L316-319 | ○ |
| C-15 | 自動化フィールドセットに異常金額無視がIconEntryで表示 | E-04 L320-323 | ○ |
| C-16 | 自動化フィールドセットに異常日付無視がIconEntryで表示 | E-04 L324-327 | ○ |
| C-17 | 内部メモタブにコメント表示がある（chat-bubble-left-rightアイコン付き） | E-04 L334-338 | ○ |
| C-18 | プレースホルダーに「-」が使用されている | E-04 L239, L243, L247等 | ○ |
| C-19 | 販売・購買タブのフィールドセットラベル | E-04 L253, L269 | ○ |
| C-20 | 請求タブのフィールドセットラベル | E-04 L291, L314 | ○ |
| C-21 | コメントフィールドはhtml()で表示 | E-04 L336 | ○ |
| C-22 | 基本情報フィールド（name, email等）が存在 | 親クラス（PartnerResource）依存 | △ |

## 4) 不足情報（Unknown / Missing）
- PartnerResourceのinfolist定義の詳細確認
  - 候補：`plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
  - 基本情報フィールドの完全なリストの確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 継承構造
- 0: 低リスク - サブナビゲーション
- 0: 低リスク - 請求関連フィールド
- 1: 中リスク - 基本情報フィールド（親クラス依存）

## 6) レビュアーチェックリスト（最小）
- [ ] PartnerResourceのinfolist定義確認
- [ ] 基本情報フィールドの完全なリスト確認
- [ ] 各アイコンの表示確認
