---
generated_at: 2025-12-26 17:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：267-仕入先価格一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Configurations/Resources/VendorPriceResource/Pages/ListVendorPrices.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Configurations/Resources/VendorPriceResource.php`
- E-03: `plugins/webkul/purchases/src/Models/ProductSupplier.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListVendorPricesはListRecordsを継承 | E-01 L12 | ○ |
| C-02 | 新規作成アクションにcreator_id自動設定 | E-01 L28 | ○ |
| C-03 | 新規作成アクションにcompany_id自動設定 | E-01 L30 | ○ |
| C-04 | クラスターはConfigurationsに属する | E-02 L46 | ○ |
| C-05 | ナビゲーションソート順は10 | E-02 L44 | ○ |
| C-06 | モデルはProductSupplier | E-02 L40 | ○ |
| C-07 | ナビゲーションアイコンはheroicon-o-archive-box | E-02 L42 | ○ |
| C-08 | formに仕入先フィールドがある | E-02 L61-69 | ○ |
| C-09 | formに仕入先商品名/コードフィールドがある | E-02 L70-77 | ○ |
| C-10 | formにリードタイムフィールドがある | E-02 L78-84 | ○ |
| C-11 | formに商品フィールドがある（is_configurable=nullフィルタ） | E-02 L93-101 | ○ |
| C-12 | formに最小数量フィールドがある | E-02 L103-109 | ○ |
| C-13 | formに単価フィールドがある | E-02 L112-118 | ○ |
| C-14 | formに通貨フィールドがある（デフォルト設定あり） | E-02 L119-125 | ○ |
| C-15 | formに有効期間フィールドがある | E-02 L126-133 | ○ |
| C-16 | formに割引フィールドがある | E-02 L136-141 | ○ |
| C-17 | formに会社フィールドがある（デフォルト設定あり） | E-02 L142-147 | ○ |
| C-18 | テーブルにreorderableColumnsが設定 | E-02 L158 | ○ |
| C-19 | テーブルにcolumnManagerColumnsが2で設定 | E-02 L159 | ○ |
| C-20 | テーブルに仕入先、商品、会社、単価、通貨カラムがある | E-02 L161-199 | ○ |
| C-21 | テーブルにグループ化オプションがある | E-02 L211-223 | ○ |
| C-22 | テーブルにSelectFilterがある（仕入先、商品、通貨、会社） | E-02 L225-251 | ○ |
| C-23 | テーブルに価格範囲フィルタがある | E-02 L253-278 | ○ |
| C-24 | テーブルに最小数量範囲フィルタがある | E-02 L280-305 | ○ |
| C-25 | テーブルに有効期間フィルタがある | E-02 L307-330 | ○ |
| C-26 | テーブルに作成日フィルタがある | E-02 L332-355 | ○ |
| C-27 | 行アクションにView, Edit, Deleteがある | E-02 L357-377 | ○ |
| C-28 | 空状態にCreateActionがある | E-02 L399-402 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目にコード根拠あり
- 0: 低リスク - フィルター設定
- 0: 低リスク - グループ化設定
- 0: 低リスク - 行アクション

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の画面表示確認
- [ ] フィルター動作確認
- [ ] 新規作成モーダルの動作確認
