---
generated_at: 2025-12-26 17:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：269-注文設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Settings/Pages/ManageOrders.php`
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageOrdersはSettingsPageを継承 | E-01 L15 | ○ |
| C-02 | HasPageShieldトレイト使用 | E-01 L17 | ○ |
| C-03 | ナビゲーションアイコンはheroicon-o-shopping-cart | E-01 L19 | ○ |
| C-04 | URLスラッグはpurchase/manage-orders | E-01 L21 | ○ |
| C-05 | ナビゲーショングループは「Purchase」 | E-01 L23 | ○ |
| C-06 | ナビゲーションソート順は1 | E-01 L25 | ○ |
| C-07 | 設定クラスはOrderSettings | E-01 L27 | ○ |
| C-08 | クラスターはSettingsに属する | E-01 L29 | ○ |
| C-09 | パンくずリストにタイトルを表示 | E-01 L31-36 | ○ |
| C-10 | getTitleでタイトルを取得 | E-01 L38-41 | ○ |
| C-11 | getNavigationLabelでナビゲーションラベルを取得 | E-01 L43-46 | ○ |
| C-12 | formメソッドでスキーマを定義 | E-01 L48-71 | ○ |
| C-13 | enable_order_approvalトグルが存在 | E-01 L54-57 | ○ |
| C-14 | order_validation_amountフィールドが存在 | E-01 L58-63 | ○ |
| C-15 | order_validation_amountはenable_order_approval時のみ表示 | E-01 L63 | ○ |
| C-16 | enable_lock_confirmed_ordersトグルが存在 | E-01 L65-67 | ○ |
| C-17 | enable_purchase_agreementsトグルが存在 | E-01 L68-70 | ○ |
| C-18 | フィールドにヘルパーテキストが設定 | E-01 L56, L67, L70 | ○ |
| C-19 | enable_order_approvalはlive()設定 | E-01 L57 | ○ |
| C-20 | 翻訳キーを使用してラベルを国際化 | E-01 L55-56, L59, L66-67, L69-70 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全項目にコード根拠あり
- 0: 低リスク - 設定フォーム構成
- 0: 低リスク - 条件付き表示ロジック
- 0: 低リスク - 権限制御

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の画面表示確認
- [ ] 設定保存動作確認
- [ ] 条件付き表示の動作確認
- [ ] 権限制御の動作確認
