---
generated_at: 2025-12-26 12:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：27-請求書編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **各アクションの詳細処理**：Actionsフォルダの実装詳細未確認
  2. **権限による表示制御**：権限設定の詳細実装未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Pages/EditInvoice.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行28）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がEditRecord | E-01: EditRecord継承 | ○ |
| C-02 | HasRecordNavigationTabsトレイトを使用 | E-01: use HasRecordNavigationTabs | ○ |
| C-03 | HasRepeaterColumnManagerトレイトを使用 | E-01: use HasRepeaterColumnManager | ○ |
| C-04 | 保存後に詳細画面へリダイレクト | E-01: getRedirectUrl() | ○ |
| C-05 | 保存成功時に通知を表示 | E-01: getSavedNotification() | ○ |
| C-06 | ヘッダーに10種類のアクションがある | E-01: getHeaderActions() | ○ |
| C-07 | ChatterActionが含まれる | E-01: ChatterActions\ChatterAction::make() | ○ |
| C-08 | PayActionが含まれる | E-01: BaseActions\PayAction::make() | ○ |
| C-09 | ConfirmActionが含まれる | E-01: BaseActions\ConfirmAction::make() | ○ |
| C-10 | CancelActionが含まれる | E-01: BaseActions\CancelAction::make() | ○ |
| C-11 | ResetToDraftActionが含まれる | E-01: BaseActions\ResetToDraftAction::make() | ○ |
| C-12 | SetAsCheckedActionが含まれる | E-01: BaseActions\SetAsCheckedAction::make() | ○ |
| C-13 | PreviewActionがテンプレートを使用 | E-01: setTemplate('accounts::invoice/actions/preview.index') | ○ |
| C-14 | PrintAndSendActionが含まれる | E-01: BaseActions\PrintAndSendAction::make() | ○ |
| C-15 | CreditNoteActionが含まれる | E-01: BaseActions\CreditNoteAction::make() | ○ |
| C-16 | DeleteActionが含まれる | E-01: DeleteAction::make() | ○ |
| C-17 | mutateFormDataBeforeSaveで値フォールバック | E-01: mutateFormDataBeforeSave() | ○ |
| C-18 | 顧客選択時にcommercial_partner_id等を設定 | E-01: mutateFormDataBeforeSave() | ○ |
| C-19 | afterSaveでcomputeAccountMove実行 | E-01: afterSave() | ○ |
| C-20 | ステータスに応じてフィールドが無効化 | E-02: disabled(fn ($record) => $record && in_array($record->state, ...)) | ○ |
| C-21 | ルーティングが/{record}/edit | E-02: getPages() 'edit' route | ○ |
| C-22 | フォーム構成は作成画面と同様 | E-02: form() | ○ |
| C-23 | 画面一覧に登録されている | E-03: No.27 請求書編集 | ○ |
| C-24 | 各アクションの詳細処理 | **根拠なし（Actions実装）** | △ |
| C-25 | 権限による表示制御の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- InvoiceResource\Actionsフォルダの各アクション実装詳細
  - 候補：`PayAction.php`, `ConfirmAction.php`, `CancelAction.php` など
- 権限設定の詳細はFilamentの権限設定またはポリシークラスの確認が必要
  - 候補：`MovePolicy.php` / `Filament Shield設定`
- Chatterパッケージの詳細

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム項目定義（ソースコードから明確）
- 0: 低リスク - ヘッダーアクション一覧（ソースコードから明確）
- 1: 中リスク - 各アクションの詳細処理（別ファイル参照必要）
- 1: 中リスク - 権限制御の詳細（別ファイル参照必要）

## 6) レビュアーチェックリスト（最小）
- [ ] InvoiceResource\Actionsフォルダの各アクション実装を確認
- [ ] 権限設定の実装内容を確認
- [ ] Chatterパッケージの動作を確認
- [ ] 多言語ファイル（accounts::filament/resources/invoice/pages/edit-invoice）の存在確認
- [ ] プレビューテンプレート（accounts::invoice/actions/preview.index）の確認
