---
generated_at: 2025-12-26 18:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：271-応募者一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **URL/ルーティング**：実際の環境での確認が必要
  2. **メッセージ仕様**：言語ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/ApplicantResource/Pages/ListApplicants.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/ApplicantResource.php`
- E-03: `plugins/webkul/recruitments/src/Models/Applicant.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はListRecords | E-01 L23 | ○ |
| C-02 | HasTableViewsトレイトを使用 | E-01 L25 | ○ |
| C-03 | JobPositionStatsWidgetをヘッダーに表示 | E-01 L29-33 | ○ |
| C-04 | 10種類のプリセットビューを提供 | E-01 L36-131 | ○ |
| C-05 | マイ応募者はrecruiter_id = Auth::id()でフィルタ | E-01 L42-45 | ○ |
| C-06 | 未アサインはrecruiter_id = NULLでフィルタ | E-01 L47-53 | ○ |
| C-07 | 進行中フィルタの条件 | E-01 L55-64 | ○ |
| C-08 | CreateActionでcandidate_idを選択 | E-01 L145-150 | ○ |
| C-09 | 既存応募者は再アクティブ化される | E-01 L167-186 | ○ |
| C-10 | 作成後は編集画面へ遷移 | E-01 L189-192 | ○ |
| C-11 | ApplicantResourceはApplicationsクラスター所属 | E-02 L67 | ○ |
| C-12 | モデルはApplicantクラス | E-02 L63 | ○ |
| C-13 | テーブル名はrecruitments_applicants | E-03 L24 | ○ |
| C-14 | SoftDeletesトレイトを使用 | E-03 L22 | ○ |
| C-15 | application_statusはアクセサで計算 | E-03 L184-195 | ○ |
| C-16 | ステージ別グループ表示がデフォルト | E-02 L651 | ○ |
| C-17 | テーブルカラム: candidate.partner.name | E-02 L402-407 | ○ |
| C-18 | テーブルカラム: create_date | E-02 L408-414 | ○ |
| C-19 | テーブルカラム: job.name | E-02 L415-420 | ○ |
| C-20 | テーブルカラム: stage.name | E-02 L421-426 | ○ |
| C-21 | QueryBuilderフィルターを使用 | E-02 L569-649 | ○ |
| C-22 | 一括削除アクションを提供 | E-02 L671-693 | ○ |
| C-23 | BLOCKEDステートはデフォルトで非表示 | E-02 L695-700 | ○ |
| C-24 | 関連機能FN-REC-001 | E-05 L160 | ○ |
| C-25 | 画面遷移：詳細・編集への遷移 | E-06 L494-495 | ○ |
| C-26 | navigationSort = 2 | E-02 L69 | ○ |
| C-27 | URL/ルーティングのパス | **根拠なし** | △ |
| C-28 | メッセージの具体的な文言 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの実際のパスはルーティング定義ファイルまたは実行環境での確認が必要
  - 候補：`routes/web.php` / Filamentパネル設定ファイル
- メッセージの具体的な文言は言語ファイルを参照する必要がある
  - 候補：`lang/ja/filament` / `recruitments::filament/*`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面構成・機能に関する記述
- 1: 中リスク - URL/ルーティングの確認が必要
- 0: 低リスク - データベース更新仕様はコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の画面でプリセットビューが正しく動作するか確認
- [ ] 新規作成時の再アクティブ化ロジックが業務要件と一致するか確認
- [ ] メッセージ文言が言語ファイルと一致するか確認
