---
generated_at: 2025-12-26 18:36:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：272-応募者編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **従業員作成ロジック**：業務フロー確認が必要
  2. **メッセージ仕様**：言語ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/ApplicantResource/Pages/EditApplicant.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/ApplicantResource.php`
- E-03: `plugins/webkul/recruitments/src/Models/Applicant.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はEditRecord | E-01 L19 | ○ |
| C-02 | 採用アクションでsetAsHired()を呼び出し | E-01 L79-83 | ○ |
| C-03 | 従業員作成アクションが存在 | E-01 L94-108 | ○ |
| C-04 | createEmployee()メソッドでEmployee作成 | E-03 L197-225 | ○ |
| C-05 | 不採用アクションでrefuse_reason_idを設定 | E-01 L119-135 | ○ |
| C-06 | setAsRefused()メソッドの存在 | E-03 L162-166 | ○ |
| C-07 | アーカイブアクションでsetAsArchived()を呼び出し | E-01 L137-148 | ○ |
| C-08 | setAsArchived()メソッドの存在 | E-03 L169-172 | ○ |
| C-09 | 再開アクションでreopen()を呼び出し | E-01 L160-163 | ○ |
| C-10 | reopen()メソッドの存在 | E-03 L174-177 | ○ |
| C-11 | フォームセクション：基本情報 | E-02 L83-109 | ○ |
| C-12 | フォームセクション：職位情報 | E-02 L110-145 | ○ |
| C-13 | フォームセクション：詳細 | E-02 L210-255 | ○ |
| C-14 | フォームセクション：ステータス | E-02 L257-310 | ○ |
| C-15 | フォームセクション：リクルーター情報 | E-02 L312-330 | ○ |
| C-16 | フォームセクション：給与情報 | E-02 L332-365 | ○ |
| C-17 | 3カラムレイアウト | E-02 L80, L374 | ○ |
| C-18 | サブナビゲーション（詳細、編集、スキル、活動） | E-02 L768-774 | ○ |
| C-19 | candidate.nameはフォームから更新 | E-02 L85-89 | ○ |
| C-20 | HasChatterトレイトを使用 | E-03 L22 | ○ |
| C-21 | HasLogActivityトレイトを使用 | E-03 L22 | ○ |
| C-22 | application_statusはアクセサ属性 | E-03 L184-195 | ○ |
| C-23 | 採用担当者はrecruiter_idで管理 | E-03 L117-119 | ○ |
| C-24 | URL/ルーティングのパス | **根拠なし** | △ |
| C-25 | メッセージの具体的な文言 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの実際のパスはルーティング定義ファイルまたは実行環境での確認が必要
- メッセージの具体的な文言は言語ファイルを参照する必要がある

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム項目の記述はコードと一致
- 1: 中リスク - 従業員作成ロジックの業務要件との整合性確認が必要
- 0: 低リスク - ステータス変更処理の実装は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 従業員作成時にパートナーが必須であることの業務妥当性を確認
- [ ] ステージ変更時のdate_last_stage_updated自動更新が実装されているか確認
- [ ] 各アクションの権限制御が適切か確認
