---
generated_at: 2025-12-26 18:37:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：273-応募者詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **URL/ルーティング**：実際の環境での確認が必要
  2. **メッセージ仕様**：言語ファイルの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/ApplicantResource/Pages/ViewApplicant.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/ApplicantResource.php`
- E-03: `plugins/webkul/recruitments/src/Models/Applicant.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はViewRecord | E-01 L19 | ○ |
| C-02 | 採用アクションが存在 | E-01 L55-85 | ○ |
| C-03 | 従業員作成アクションが存在 | E-01 L87-108 | ○ |
| C-04 | 不採用アクションが存在 | E-01 L110-138 | ○ |
| C-05 | アーカイブアクションが存在 | E-01 L140-155 | ○ |
| C-06 | 再開アクションが存在 | E-01 L157-172 | ○ |
| C-07 | infolistセクション：候補者情報 | E-02 L482-515 | ○ |
| C-08 | infolistセクション：職位情報 | E-02 L517-540 | ○ |
| C-09 | infolistセクション：ソース情報 | E-02 L541-555 | ○ |
| C-10 | infolistセクション：選考情報 | E-02 L558-609 | ○ |
| C-11 | infolistセクション：担当者情報 | E-02 L610-635 | ○ |
| C-12 | infolistセクション：給与情報 | E-02 L636-658 | ○ |
| C-13 | 3カラムレイアウト | E-02 L479 | ○ |
| C-14 | priorityは星アイコンでカスタム表示 | E-02 L582-595 | ○ |
| C-15 | application_statusはEnumから表示情報を取得 | E-02 L600-609 | ○ |
| C-16 | プレースホルダー「—」を使用 | E-02 L486 | ○ |
| C-17 | 各項目にアイコンを設定 | E-02 L483-485 | ○ |
| C-18 | サブナビゲーション | E-02 L768-774 | ○ |
| C-19 | applicationStatusはアクセサ属性 | E-03 L184-195 | ○ |
| C-20 | ApplicationStatusはEnum | E-03 L13 | ○ |
| C-21 | URL/ルーティングのパス | **根拠なし** | △ |
| C-22 | メッセージの具体的な文言 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの実際のパスはルーティング定義ファイルまたは実行環境での確認が必要
- メッセージの具体的な文言は言語ファイルを参照する必要がある

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 表示項目の記述はコードと一致
- 0: 低リスク - ヘッダーアクションの実装は確認済み
- 1: 中リスク - アクションの表示/非表示制御の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各アクションボタンの表示条件が業務要件と一致するか確認
- [ ] 採用済み・不採用後の画面表示が適切か確認
- [ ] リンク項目（メール、LinkedIn）が正しく動作するか確認
