---
generated_at: 2025-12-26 18:38:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：274-候補者一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：実際の環境での確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/CandidateResource/Pages/ListCandidates.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/CandidateResource.php`
- E-03: `plugins/webkul/recruitments/src/Models/Candidate.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はListRecords | E-01 L19 | ○ |
| C-02 | CandidateResourceはApplicationsクラスター所属 | E-02 L53 | ○ |
| C-03 | navigationSort = 3 | E-02 L55 | ○ |
| C-04 | モデルはCandidateクラス | E-02 L49 | ○ |
| C-05 | テーブルはグリッドレイアウト（md:2, xl:3） | E-02 L211-214 | ○ |
| C-06 | カラム: name（太字表示） | E-02 L170-174 | ○ |
| C-07 | カラム: categories.name（バッジ表示） | E-02 L176-188 | ○ |
| C-08 | カラム: priority（星評価） | E-02 L189-204 | ○ |
| C-09 | フィルター: company | E-02 L220-230 | ○ |
| C-10 | フィルター: partner | E-02 L231-241 | ○ |
| C-11 | フィルター: degree | E-02 L242-252 | ○ |
| C-12 | フィルター: manager | E-02 L253-263 | ○ |
| C-13 | グループ化: manager.name | E-02 L266-270 | ○ |
| C-14 | 行アクション: View, Edit, Delete | E-02 L271-280 | ○ |
| C-15 | 一括削除アクション | E-02 L283-291 | ○ |
| C-16 | 空状態アクション: Create | E-02 L293-301 | ○ |
| C-17 | デフォルトソート: created_at desc | E-02 L303 | ○ |
| C-18 | SoftDeletesトレイトを使用 | E-03 L18 | ○ |
| C-19 | テーブル名はrecruitments_candidates | E-03 L20 | ○ |
| C-20 | URL/ルーティングのパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの実際のパスはルーティング定義ファイルまたは実行環境での確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 表示項目・フィルターの記述はコードと一致
- 0: 低リスク - グリッドレイアウト設定は確認済み
- 0: 低リスク - アクションの実装は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] カードレイアウトの表示が意図通りか確認
- [ ] タグの色表示が正しく動作するか確認
- [ ] 星評価のカスタムHTML表示が適切か確認
