---
generated_at: 2025-12-26 18:39:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：275-候補者作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：実際の環境での確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/CandidateResource/Pages/CreateCandidate.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/CandidateResource.php`
- E-03: `plugins/webkul/recruitments/src/Models/Candidate.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はCreateRecord | E-01 L19 | ○ |
| C-02 | 作成成功通知を表示 | E-01 L23-30 | ○ |
| C-03 | フォームセクション：基本情報 | E-02 L84-106 | ○ |
| C-04 | フォームセクション：追加詳細 | E-02 L107-129 | ○ |
| C-05 | フォームセクション：ステータス・評価 | E-02 L133-157 | ○ |
| C-06 | 3カラムレイアウト | E-02 L160-161 | ○ |
| C-07 | creator_idはHiddenでAuth::id()をデフォルト | E-02 L86-87 | ○ |
| C-08 | nameは必須、最大255文字 | E-02 L88-91 | ○ |
| C-09 | email_fromはlive()バリデーション | E-02 L92-96 | ○ |
| C-10 | phoneはtel、最大255文字 | E-02 L97-100 | ○ |
| C-11 | linkedin_profileはurl、最大255文字 | E-02 L101-105 | ○ |
| C-12 | degree_idはsearchable, preload | E-02 L109-113 | ○ |
| C-13 | is_activeはtoggle、デフォルトtrue | E-02 L136-139 | ○ |
| C-14 | パートナー自動作成（saved時） | E-03 L127-138 | ○ |
| C-15 | handlePartnerCreation()の実装 | E-03 L143-156 | ○ |
| C-16 | パートナー作成時のフィールド設定 | E-03 L145-152 | ○ |
| C-17 | 2カラムレイアウト（各セクション内） | E-02 L106, L129 | ○ |
| C-18 | テーブル名はrecruitments_candidates | E-03 L20 | ○ |
| C-19 | fillableフィールドの定義 | E-03 L22-39 | ○ |
| C-20 | URL/ルーティングのパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの実際のパスはルーティング定義ファイルまたは実行環境での確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム項目の記述はコードと一致
- 0: 低リスク - パートナー自動作成ロジックは確認済み
- 1: 中リスク - パートナー作成失敗時のロールバック動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 候補者作成時にパートナーが正しく自動作成されるか確認
- [ ] バリデーションエラー時の表示が適切か確認
- [ ] 作成後の遷移先が正しいか確認
