---
generated_at: 2025-12-26 18:41:00
metrics:
  claims_total: 19
  claims_with_evidence: 18
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：277-候補者詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：18 / 19、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：実際の環境での確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/CandidateResource/Pages/ViewCandidate.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/CandidateResource.php`
- E-03: `plugins/webkul/recruitments/src/Models/Candidate.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はViewRecord | E-01 L19 | ○ |
| C-02 | infolistセクション：基本情報 | E-02 L314-337 | ○ |
| C-03 | infolistセクション：追加詳細 | E-02 L339-373 | ○ |
| C-04 | infolistセクション：ステータス・評価 | E-02 L378-400 | ○ |
| C-05 | infolistセクション：コミュニケーション | E-02 L401-410 | ○ |
| C-06 | 3カラムレイアウト | E-02 L310 | ○ |
| C-07 | name項目にアイコン設定 | E-02 L316-317 | ○ |
| C-08 | email_from項目にアイコン設定 | E-02 L324-325 | ○ |
| C-09 | linkedin_profileはURL表示 | E-02 L332-336 | ○ |
| C-10 | categories.nameはバッジ表示 | E-02 L349-361 | ○ |
| C-11 | Color::generateV3Paletteを使用 | E-02 L360 | ○ |
| C-12 | priorityは星アイコンでカスタム表示 | E-02 L384-398 | ○ |
| C-13 | is_activeはIconEntry（ブール値） | E-02 L380-382 | ○ |
| C-14 | message_bouncedはIconEntry | E-02 L407-409 | ○ |
| C-15 | プレースホルダー「—」を使用 | E-02 L318 | ○ |
| C-16 | サブナビゲーション（詳細、編集、スキル） | E-02 L417-423 | ○ |
| C-17 | 2カラムレイアウト（各セクション内） | E-02 L337, L372 | ○ |
| C-18 | ページ登録（view） | E-02 L442 | ○ |
| C-19 | URL/ルーティングのフルパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの実際のパスはルーティング定義ファイルまたは実行環境での確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 表示項目の記述はコードと一致
- 0: 低リスク - レイアウト設定は確認済み
- 0: 低リスク - サブナビゲーションの設定は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] LinkedInリンクが正しく外部サイトへ遷移するか確認
- [ ] タグの色表示が正しく動作するか確認
- [ ] 星評価のカスタムHTML表示が適切か確認
