---
generated_at: 2025-12-26 18:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：278-職位別求人一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：実際の環境での確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/JobByPositionResource/Pages/ListJobByPositions.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Applications/Resources/JobByPositionResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はListRecords | E-01 L19 | ○ |
| C-02 | モデルはJobPositionクラス | E-02 L22 | ○ |
| C-03 | ApplicationsクラスターのナビゲーションSort = 1 | E-02 L28 | ○ |
| C-04 | グリッドレイアウト（md:2, xl:2） | E-02 L82-85 | ○ |
| C-05 | カラム: name（太字表示） | E-02 L57-62 | ○ |
| C-06 | カラム: department.manager.name | E-02 L63-69 | ○ |
| C-07 | カラム: company.name（条件表示） | E-02 L71-78 | ○ |
| C-08 | withCountでnew_applicants_countを取得 | E-02 L48-50 | ○ |
| C-09 | withCountでtotal_applicants_countを取得 | E-02 L51 | ○ |
| C-10 | 新規応募者ボタンアクション | E-02 L87-125 | ○ |
| C-11 | stage_id = 1 でフィルタリング | E-02 L104-110 | ○ |
| C-12 | 採用予定ボタン（EditAction） | E-02 L127-135 | ○ |
| C-13 | 総応募者ボタンアクション | E-02 L136-164 | ○ |
| C-14 | フォーム定義はJobPositionResourceから継承 | E-02 L40-43 | ○ |
| C-15 | infolist定義はJobPositionResourceから継承 | E-02 L169-172 | ○ |
| C-16 | ページ登録（index） | E-02 L177 | ○ |
| C-17 | ApplicantResource::getUrl()で遷移 | E-02 L99, L147 | ○ |
| C-18 | URL/ルーティングのフルパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの実際のパスはルーティング定義ファイルまたは実行環境での確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 表示項目・アクションの記述はコードと一致
- 1: 中リスク - 遷移先URLのフィルターパラメータ形式の確認が必要
- 0: 低リスク - withCountクエリの実装は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 新規応募者ボタンのフィルター遷移が正しく動作するか確認
- [ ] 採用予定編集モーダルが正しく動作するか確認
- [ ] 応募者数のカウントが正確か確認
