---
generated_at: 2025-12-26 18:43:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：279-ステージ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：実際の環境での確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/StageResource/Pages/ListStages.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/StageResource.php`
- E-03: `plugins/webkul/recruitments/src/Models/Stage.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はListRecords | E-01 L19 | ○ |
| C-02 | モデルはStageクラス | E-02 L44 | ○ |
| C-03 | ConfigurationsクラスターのナビゲーションSort = 1 | E-02 L48 | ○ |
| C-04 | reorderableColumns() | E-02 L140 | ○ |
| C-05 | columnManagerColumns(2) | E-02 L141 | ○ |
| C-06 | カラム: id（非表示） | E-02 L143-146 | ○ |
| C-07 | カラム: name（検索・ソート可） | E-02 L147-150 | ○ |
| C-08 | カラム: jobs.name（バッジ表示） | E-02 L151-154 | ○ |
| C-09 | カラム: is_default（IconColumn） | E-02 L155-157 | ○ |
| C-10 | カラム: fold（IconColumn） | E-02 L158-160 | ○ |
| C-11 | カラム: hired_stage（IconColumn） | E-02 L161-163 | ○ |
| C-12 | フィルター: QueryBuilder使用 | E-02 L181-229 | ○ |
| C-13 | グループ化オプション（8種類） | E-02 L232-258 | ○ |
| C-14 | 行アクション: View, Edit, Delete | E-02 L264-286 | ○ |
| C-15 | 削除時のQueryExceptionキャッチ | E-02 L268-278 | ○ |
| C-16 | 一括削除アクション | E-02 L287-296 | ○ |
| C-17 | 空状態アクション: Create | E-02 L259-262 | ○ |
| C-18 | 並び替え: reorderable('sort', 'Desc') | E-02 L298 | ○ |
| C-19 | SortableTraitを使用 | E-03 L15 | ○ |
| C-20 | order_column_name = 'sort' | E-03 L38-41 | ○ |
| C-21 | テーブル名はrecruitments_stages | E-03 L17 | ○ |
| C-22 | fillableフィールドの定義 | E-03 L19-30 | ○ |
| C-23 | jobsリレーション | E-03 L48-51 | ○ |
| C-24 | URL/ルーティングのフルパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの実際のパスはルーティング定義ファイルまたは実行環境での確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 表示項目・フィルターの記述はコードと一致
- 0: 低リスク - 並び替え機能の実装は確認済み
- 1: 中リスク - 削除時の外部キー制約エラー処理の動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ドラッグ＆ドロップ並び替えが正しく動作するか確認
- [ ] 削除時の外部キー制約エラーメッセージが適切か確認
- [ ] 職位のバッジ表示が正しく動作するか確認
