---
generated_at: 2025-12-26 12:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：28-請求書詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **各アクションの詳細処理**：Actionsフォルダの実装詳細未確認
  2. **権限による表示制御**：権限設定の詳細実装未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Pages/ViewInvoice.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行29）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がViewRecord | E-01: ViewRecord継承 | ○ |
| C-02 | HasRecordNavigationTabsトレイトを使用 | E-01: use HasRecordNavigationTabs | ○ |
| C-03 | HasRepeatableEntryColumnManagerトレイトを使用 | E-01: use HasRepeatableEntryColumnManager | ○ |
| C-04 | ヘッダーに10種類のアクションがある | E-01: getHeaderActions() | ○ |
| C-05 | 削除アクションに成功通知がある | E-01: DeleteAction->successNotification() | ○ |
| C-06 | infolistに1カラムレイアウト | E-02: infolist() columns(1) | ○ |
| C-07 | 支払ステータスがバッジ表示 | E-02: TextEntry payment_state badge() | ○ |
| C-08 | 基本情報セクションがある | E-02: Section general.title | ○ |
| C-09 | 請求明細がRepeatableEntry | E-02: RepeatableEntry::make('lines') | ○ |
| C-10 | 明細にcolumnManager機能がある | E-02: ->columnManager() | ○ |
| C-11 | 明細がテーブル形式 | E-02: ->table([...]) | ○ |
| C-12 | InvoiceSummary Livewireコンポーネント使用 | E-02: Livewire::make(InvoiceSummary::class) | ○ |
| C-13 | 3つのタブ構成 | E-02: Tabs invoice-lines, other-information, terms | ○ |
| C-14 | その他情報に4つのセクション | E-02: Section invoice, accounting, additional, marketing | ○ |
| C-15 | 各項目にアイコンが設定 | E-02: ->icon('heroicon-o-...') | ○ |
| C-16 | 各項目にプレースホルダー | E-02: ->placeholder('-') | ○ |
| C-17 | 利用規約がHTML表示 | E-02: TextEntry narration html() | ○ |
| C-18 | 金額が通貨フォーマット | E-02: money(fn ($record) => $record->currency?->name) | ○ |
| C-19 | ルーティングが/{record} | E-02: getPages() 'view' route | ○ |
| C-20 | 画面一覧に登録されている | E-03: No.28 請求書詳細 | ○ |
| C-21 | 各アクションの詳細処理 | **根拠なし（Actions実装）** | △ |
| C-22 | 権限による表示制御の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- InvoiceResource\Actionsフォルダの各アクション実装詳細
- 権限設定の詳細はFilamentの権限設定またはポリシークラスの確認が必要
  - 候補：`MovePolicy.php` / `Filament Shield設定`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 表示項目定義（ソースコードから明確）
- 0: 低リスク - レイアウト構成（ソースコードから明確）
- 1: 中リスク - 各アクションの詳細処理（別ファイル参照必要）
- 1: 中リスク - 権限制御の詳細（別ファイル参照必要）

## 6) レビュアーチェックリスト（最小）
- [ ] InvoiceResource\Actionsフォルダの各アクション実装を確認
- [ ] 権限設定の実装内容を確認
- [ ] 多言語ファイル（accounts::filament/resources/invoice/pages/view-invoice）の存在確認
- [ ] InvoiceSummary Livewireコンポーネントの動作確認
