---
generated_at: 2025-12-26 18:44:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：280-ステージ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：実際の環境での確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/StageResource/Pages/CreateStage.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/StageResource.php`
- E-03: `plugins/webkul/recruitments/src/Models/Stage.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はCreateRecord | E-01 L19 | ○ |
| C-02 | 3カラムレイアウト | E-02 L132 | ○ |
| C-03 | フォームセクション：一般情報 | E-02 L76-88 | ○ |
| C-04 | フォームセクション：ツールチップ | E-02 L94-114 | ○ |
| C-05 | フォームセクション：追加情報 | E-02 L115-128 | ○ |
| C-06 | creator_idはHiddenでAuth::id()をデフォルト | E-02 L78-80 | ○ |
| C-07 | nameは必須 | E-02 L81-83 | ○ |
| C-08 | requirementsはRichEditor、最大255文字 | E-02 L84-87 | ○ |
| C-09 | legend_normalは必須、デフォルト「In Progress」 | E-02 L97-101 | ○ |
| C-10 | legend_blockedは必須、デフォルト「Blocked」 | E-02 L102-107 | ○ |
| C-11 | legend_doneは必須、デフォルト「Ready for Next Stage」 | E-02 L108-113 | ○ |
| C-12 | 職位はmulti-select | E-02 L117-121 | ○ |
| C-13 | foldはtoggle | E-02 L122-123 | ○ |
| C-14 | hired_stageはtoggle | E-02 L124-125 | ○ |
| C-15 | is_defaultはtoggle | E-02 L126-127 | ○ |
| C-16 | ツールチップセクションに説明文を設定 | E-02 L95 | ○ |
| C-17 | 各ラベルにヒントアイコンを設定 | E-02 L100, L105-106, L111-112 | ○ |
| C-18 | sort_when_creating = true | E-03 L40 | ○ |
| C-19 | jobsリレーション（多対多） | E-03 L48-51 | ○ |
| C-20 | 中間テーブル: recruitments_stages_jobs | E-03 L50 | ○ |
| C-21 | ページ登録（create） | E-02 L372 | ○ |
| C-22 | URL/ルーティングのフルパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの実際のパスはルーティング定義ファイルまたは実行環境での確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム項目の記述はコードと一致
- 0: 低リスク - デフォルト値の設定は確認済み
- 1: 中リスク - 職位を選択しない場合の動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ラベルのデフォルト値が適切か確認
- [ ] 職位との関連付けが正しく動作するか確認
- [ ] sort値の自動設定が正しく動作するか確認
