---
generated_at: 2025-12-26 19:08:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：285-職位詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/JobPositionResource/Pages/ViewJobPosition.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/JobPositionResource.php`
- E-03: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/JobPositionResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面クラスはViewRecordを継承 | E-01 | ○ |
| C-02 | ベースクラスとして従業員モジュールのViewJobPositionを継承 | E-01 | ○ |
| C-03 | InfolistにnameEntryが存在 | E-03 | ○ |
| C-04 | Infolistにdepartment.nameEntryが存在 | E-03 | ○ |
| C-05 | Infolistにcompany.nameEntryが存在 | E-03 | ○ |
| C-06 | Infolistにexpected_employeesEntryが存在 | E-03 | ○ |
| C-07 | Infolistにno_of_employeeEntryが存在 | E-03 | ○ |
| C-08 | Infolistにno_of_recruitmentEntryが存在 | E-03 | ○ |
| C-09 | Infolistにis_activeIconEntryが存在 | E-03 | ○ |
| C-10 | InfolistにdescriptionEntryがHTML形式で存在 | E-03 | ○ |
| C-11 | 3カラムレイアウト（左2、右1）で表示 | E-03 | ○ |
| C-12 | 画面一覧でNo.285として登録 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく仕様のため、実装との整合性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] 各表示項目のアイコン表示確認
- [ ] HTML形式表示の動作確認
- [ ] 計算フィールドの表示値確認
