---
generated_at: 2025-12-26 18:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：291-UTMメディア一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **URL/ルーティング**：実際のルーティング設定との照合が必要
  2. **権限制御の詳細**：権限設定の具体的な実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/UTMMediumResource.php`
- E-02: `plugins/webkul/recruitments/src/Filament/Clusters/Configurations/Resources/UTMMediumResource/Pages/ListUTMMedia.php`
- E-03: `plugins/webkul/recruitments/src/Models/UTMMedium.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はSimpleResourceパターンである | E-01 (getPages配列にindexのみ定義) | ○ |
| C-02 | テーブルにID, name, createdBy.name, created_at, updated_atカラムがある | E-01 (table関数定義) | ○ |
| C-03 | 新規作成はモーダルダイアログで行われる | E-02 (CreateAction::make) | ○ |
| C-04 | フィルターはQueryBuilderベースである | E-01 (QueryBuilder::make) | ○ |
| C-05 | 名称は必須で最大255文字 | E-01 (TextInput::make('name')->required()->maxLength(255)) | ○ |
| C-06 | ID列はデフォルト非表示 | E-01 (toggleable(isToggledHiddenByDefault: true)) | ○ |
| C-07 | 削除・編集・表示アクションがある | E-01 (ViewAction, EditAction, DeleteAction) | ○ |
| C-08 | 一括削除機能がある | E-01 (DeleteBulkAction) | ○ |
| C-09 | モデルはWebkul\Support\Models\UTMMediumを継承 | E-03 | ○ |
| C-10 | URLスラグはutm-mediumsである | E-01 (getSlug関数) | ○ |
| C-11 | ナビゲーショングループは設定カテゴリ | E-01 (getNavigationGroup) | ○ |
| C-12 | クラスターはConfigurationsである | E-01 (cluster = Configurations::class) | ○ |
| C-13 | ナビゲーションアイコンはheroicon-o-arrow-path-rounded-square | E-01 | ○ |
| C-14 | 成功通知が各操作後に表示される | E-01, E-02 (successNotification定義) | ○ |
| C-15 | InfolistでnameエントリーがIssueされる | E-01 (infolist関数) | ○ |
| C-16 | テーブルのフィルターはTextConstraintでname検索 | E-01 | ○ |
| C-17 | URL/ルーティングは/recruitments/configurations/utm-mediums | **根拠不足** | △ |
| C-18 | 権限による表示制御の詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの完全なパス
  - 候補：RouteServiceProvider / Filamentパネル設定ファイル / web.php
- 権限設定の詳細
  - 候補：Policy定義 / Gate設定 / Filament権限設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD機能は正確に記述されている
- 1: 中リスク - ルーティングパスの検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] UTMメディアモデルの継承関係を確認
- [ ] 実際のURLパスをブラウザで確認
- [ ] 権限設定の実装状況を確認
- [ ] 多言語対応のラベルが正しく設定されているか確認
