---
generated_at: 2025-12-26 18:38:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：293-見積書一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **URL/ルーティング**：Filamentパネル設定との照合
  2. **多言語対応ラベル**：翻訳ファイルとの整合性確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Pages/ListQuotations.php`
- E-03: `plugins/webkul/sales/src/Models/Order.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | モデルはOrder::classを使用 | E-01 ($model = Order::class) | ○ |
| C-02 | テーブルカラムにname, state, invoice_status等がある | E-01 (table関数) | ○ |
| C-03 | フィルターはQueryBuilderベースである | E-01 (QueryBuilder::make) | ○ |
| C-04 | グルーピング機能がある | E-01 (Tables\Grouping\Group) | ○ |
| C-05 | 金額カラムにSum集計がある | E-01 (Summarizers\Sum) | ○ |
| C-06 | SoftDeletes機能を使用 | E-03 (use SoftDeletes) | ○ |
| C-07 | 削除アクションがSALE状態で非表示 | E-01 (hidden条件) | ○ |
| C-08 | 完全削除・復元アクションがある | E-01 (ForceDeleteAction, RestoreAction) | ○ |
| C-09 | バルクアクションで一括削除等が可能 | E-01 (BulkActionGroup) | ○ |
| C-10 | カラム並び替えが可能 | E-01 (reorderableColumns()) | ○ |
| C-11 | カラムマネージャーで2カラム表示 | E-01 (columnManagerColumns(2)) | ○ |
| C-12 | ナビゲーションアイコンはheroicon-o-document-text | E-01 | ○ |
| C-13 | クラスターはOrders::classである | E-01 | ○ |
| C-14 | navigationSortは1である | E-01 | ○ |
| C-15 | 通貨はレコードごとに動的取得 | E-01 (money(fn ($record) => $record->currency->code)) | ○ |
| C-16 | フィルターは2カラム表示 | E-01 (filtersFormColumns(2)) | ○ |
| C-17 | checkIfRecordIsSelectableでSALE状態を除外 | E-01 | ○ |
| C-18 | modifyQueryUsingでcurrencyをeagerload | E-01 | ○ |
| C-19 | 成功通知が各操作後に表示される | E-01 (successNotification) | ○ |
| C-20 | フィルターにRelationshipConstraintを使用 | E-01 | ○ |
| C-21 | DateConstraintで日付フィルター | E-01 | ○ |
| C-22 | グループ化は折りたたみ可能 | E-01 (collapsible()) | ○ |
| C-23 | テーブルカラムはtoggleable | E-01 | ○ |
| C-24 | recordTitleAttributeはname | E-01 | ○ |
| C-25 | ViewAction, EditAction, DeleteActionがある | E-01 | ○ |
| C-26 | getModelLabel/getNavigationLabelで多言語対応 | E-01 | ○ |
| C-27 | URL/ルーティングの詳細パス | **根拠不足** | △ |
| C-28 | 権限制御の詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの完全なパス
  - 候補：Filamentパネル設定 / RouteServiceProvider
- 権限設定の詳細
  - 候補：Policy定義 / Gate設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な機能は正確に記述されている
- 1: 中リスク - 複雑なビジネスロジック（受注変換等）は別画面で実装

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のURLパスをブラウザで確認
- [ ] フィルター条件の動作確認
- [ ] グルーピング機能の動作確認
- [ ] SALE状態レコードの削除不可を確認
- [ ] 通貨表示の正確性確認
