---
generated_at: 2025-12-26 18:40:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：294-見積書作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **商品明細Repeaterの詳細仕様**：getProductRepeater関数の詳細確認
  2. **サマリー計算ロジック**：Livewireコンポーネントの実装確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Pages/CreateQuotation.php`
- E-03: `plugins/webkul/sales/src/Models/Order.php`
- E-04: `plugins/webkul/sales/src/Livewire/Summary.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProgressStepperでステータス表示 | E-01 (ProgressStepper::make('state')) | ○ |
| C-02 | デフォルトステータスはDraft | E-01 (default(OrderState::DRAFT->value)) | ○ |
| C-03 | ステータスは非活性 | E-01 (disabled()) | ○ |
| C-04 | 顧客はcustomer sub_typeでフィルター | E-01 (where('sub_type', 'customer')) | ○ |
| C-05 | 顧客選択でwithTrashedを使用 | E-01 | ○ |
| C-06 | 顧客選択時に担当者・支払条件を自動設定 | E-01 (afterStateUpdated) | ○ |
| C-07 | 有効期限のデフォルト日数は設定から取得 | E-01 (QuotationAndOrderSettings) | ○ |
| C-08 | 見積日のデフォルトは今日 | E-01 (default(now())) | ○ |
| C-09 | 支払条件のデフォルトはID:10 | E-01 (default(PaymentTerm::find(10)?->id)) | ○ |
| C-10 | タブ構成（商品明細、オプション、その他情報、利用規約） | E-01 (Tabs::make) | ○ |
| C-11 | 商品明細はRepeater形式 | E-01 (getProductRepeater()) | ○ |
| C-12 | サマリーはLivewireコンポーネント | E-01 (Livewire::make(Summary::class)) | ○ |
| C-13 | 営業フィールドセット | E-01 (Fieldset sales) | ○ |
| C-14 | 配送フィールドセット | E-01 (Fieldset shipping) | ○ |
| C-15 | トラッキングフィールドセット | E-01 (Fieldset tracking) | ○ |
| C-16 | 追加情報フィールドセット | E-01 (Fieldset additional-information) | ○ |
| C-17 | 利用規約はRichEditor | E-01 (RichEditor::make('note')) | ○ |
| C-18 | 会社選択で通貨を自動設定 | E-01 (afterStateUpdated currency_id) | ○ |
| C-19 | 会社のデフォルトはログインユーザーの会社 | E-01 (default(Auth::user()->default_company_id)) | ○ |
| C-20 | 通貨のデフォルトは会社の通貨 | E-01 | ○ |
| C-21 | 削除済み顧客は選択不可 | E-01 (disableOptionWhen) | ○ |
| C-22 | オプション商品タブはCANCEL状態で非表示 | E-01 (hidden条件) | ○ |
| C-23 | キャンペーン選択フィールドがある | E-01 (campaign_id) | ○ |
| C-24 | メディア選択フィールドがある | E-01 (medium_id) | ○ |
| C-25 | UTMソース選択フィールドがある | E-01 (utm_source_id) | ○ |
| C-26 | 顧客参照番号は最大255文字 | E-01 | ○ |
| C-27 | ソースドキュメントは最大255文字 | E-01 (maxLength(255)) | ○ |
| C-28 | タグは複数選択可能 | E-01 (multiple()) | ○ |
| C-29 | フォームは1カラムレイアウト | E-01 (columns(1)) | ○ |
| C-30 | 通貨は必須 | E-01 (required()) | ○ |
| C-31 | 商品明細Repeaterの詳細仕様 | **別メソッド参照必要** | △ |
| C-32 | サマリー計算ロジックの詳細 | **Livewireクラス参照必要** | △ |

## 4) 不足情報（Unknown / Missing）
- getProductRepeater関数の詳細実装
  - 候補：QuotationResource.php内の別メソッド
- Summary Livewireコンポーネントの計算ロジック
  - 候補：plugins/webkul/sales/src/Livewire/Summary.php

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構造は正確に記述されている
- 1: 中リスク - 商品明細の詳細動作は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 顧客選択時の自動設定動作確認
- [ ] 会社選択時の通貨自動設定確認
- [ ] 商品明細の入力動作確認
- [ ] サマリー計算の正確性確認
- [ ] 有効期限のデフォルト日数設定確認
- [ ] 見積書番号の自動採番確認
