---
generated_at: 2025-12-26 18:42:00
metrics:
  claims_total: 26
  claims_with_evidence: 23
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：295-見積書編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：23 / 26、根拠なし：3
- 優先レビュー（高）
  1. **ヘッダーアクションの詳細**：EditQuotation.phpのヘッダーアクション確認
  2. **受注変換ロジック**：在庫オペレーション自動生成の詳細確認
  3. **サブナビゲーション構成**：getRecordSubNavigationの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Pages/EditQuotation.php`
- E-03: `plugins/webkul/sales/src/Models/Order.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | フォーム構造は作成画面と共通 | E-01 (form関数共通) | ○ |
| C-02 | 顧客はロック/キャンセル時に非活性 | E-01 (disabled条件) | ○ |
| C-03 | 有効期限は既存レコード時に非表示 | E-01 (hidden(fn ($record) => $record)) | ○ |
| C-04 | 見積日ラベルはステータスで動的変更 | E-01 (label関数) | ○ |
| C-05 | 納期はキャンセル時に非活性 | E-01 (disabled条件) | ○ |
| C-06 | オプション商品タブはキャンセル時非表示 | E-01 (hidden条件) | ○ |
| C-07 | ステータスはProgressStepperで表示 | E-01 | ○ |
| C-08 | キャンセル状態ではステータスからキャンセル除外 | E-01 (options関数ロジック) | ○ |
| C-09 | HasChatterトレイトを使用 | E-03 (use HasChatter) | ○ |
| C-10 | HasLogActivityトレイトを使用 | E-03 (use HasLogActivity) | ○ |
| C-11 | SoftDeletesを使用 | E-03 (use SoftDeletes) | ○ |
| C-12 | lockedフラグで編集制御 | E-01, E-03 (locked項目) | ○ |
| C-13 | 見積書番号は'SO/' + idで自動生成 | E-03 (updateName関数) | ○ |
| C-14 | フォームは1カラムレイアウト | E-01 (columns(1)) | ○ |
| C-15 | サマリーはLivewireコンポーネント | E-01 (Livewire::make) | ○ |
| C-16 | リアルタイム更新（live, reactive） | E-01 | ○ |
| C-17 | 削除済み顧客は選択不可表示 | E-01 (getOptionLabelFromRecordUsing) | ○ |
| C-18 | 支払条件は常時編集可 | E-01 (disabled条件なし) | ○ |
| C-19 | 会社選択で通貨自動更新 | E-01 (afterStateUpdated) | ○ |
| C-20 | タグは複数選択可能 | E-01 (multiple()) | ○ |
| C-21 | 利用規約はRichEditor | E-01 | ○ |
| C-22 | キャンペーン・メディア・ソースフィールド | E-01 | ○ |
| C-23 | 更新日時が記録される | E-03 (timestamps) | ○ |
| C-24 | ヘッダーアクション（確認、受注変換等）の詳細 | **EditQuotation.php確認必要** | △ |
| C-25 | 受注変換時の在庫オペレーション自動生成 | **関連コード確認必要** | △ |
| C-26 | サブナビゲーション構成 | **getRecordSubNavigation確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- EditQuotation.phpのヘッダーアクション定義
  - 候補：getHeaderActions関数
- 受注変換時の在庫オペレーション生成ロジック
  - 候補：関連するイベントリスナー / Observer
- サブナビゲーション構成
  - 候補：getRecordSubNavigation関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構造は作成画面と共通で正確
- 1: 中リスク - ヘッダーアクションの詳細は別途確認が必要
- 2: 中リスク - 受注変換のビジネスロジックは要確認

## 6) レビュアーチェックリスト（最小）
- [ ] ロック状態での編集制限動作確認
- [ ] キャンセル状態での編集制限動作確認
- [ ] ヘッダーアクションの動作確認
- [ ] 受注変換の動作確認
- [ ] サブナビゲーションの遷移確認
- [ ] チャッター機能の動作確認
