---
generated_at: 2025-12-26 18:44:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：296-見積書詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **ヘッダーアクションの詳細**：ViewQuotation.phpのアクション確認
  2. **サブナビゲーション構成**：getRecordSubNavigation確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource/Pages/ViewQuotation.php`
- E-03: `plugins/webkul/sales/src/Models/Order.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Infolist形式で表示 | E-01 (infolist関数) | ○ |
| C-02 | ステータスはバッジ表示 | E-01 (TextEntry::make('state')->badge()) | ○ |
| C-03 | コンパクトセクションでステータス表示 | E-01 (Section::make()->compact()) | ○ |
| C-04 | 見積書番号は太字・大サイズ | E-01 (weight('bold'), size(TextSize::Large)) | ○ |
| C-05 | アイコン付きテキストエントリー | E-01 (icon()) | ○ |
| C-06 | 日付形式で有効期限・見積日表示 | E-01 (date()) | ○ |
| C-07 | タブ形式で商品明細等を表示 | E-01 (Tabs::make()) | ○ |
| C-08 | RepeatableEntryで商品明細表示 | E-01 | ○ |
| C-09 | カラムマネージャーで2カラム | E-01 (columnManagerColumns(2)) | ○ |
| C-10 | 商品名は幅250px | E-01 (width(250)) | ○ |
| C-11 | 単位表示はenable_uom設定依存 | E-01 (visible条件) | ○ |
| C-12 | パッケージング表示はenable_packagings設定依存 | E-01 (visible条件) | ○ |
| C-13 | マージン表示はenable_margin設定依存 | E-01 (visible条件) | ○ |
| C-14 | 割引表示はenable_discount設定依存 | E-01 (visible条件) | ○ |
| C-15 | 通貨はレコードごとのcurrency.code | E-01 (money(fn ($record) => ...)) | ○ |
| C-16 | 税はバッジ形式で複数表示 | E-01 (badge(), state配列) | ○ |
| C-17 | 商品名にツールチップ | E-01 (tooltip()) | ○ |
| C-18 | リードタイムは日数suffix付き | E-01 (suffix(' days')) | ○ |
| C-19 | placeholder'-'で未設定時表示 | E-01 (placeholder('-')) | ○ |
| C-20 | 単価はFontWeight::Medium | E-01 | ○ |
| C-21 | toggleableでカラム表示切替 | E-01 | ○ |
| C-22 | liveでリアルタイム更新 | E-01 (live()) | ○ |
| C-23 | ヘッダーアクションの詳細 | **ViewQuotation.php確認必要** | △ |
| C-24 | サブナビゲーション構成 | **getRecordSubNavigation確認必要** | △ |

## 4) 不足情報（Unknown / Missing）
- ViewQuotation.phpのヘッダーアクション定義
  - 候補：getHeaderActions関数
- サブナビゲーション構成の詳細
  - 候補：getRecordSubNavigation関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Infolist構造は正確に記述されている
- 1: 低リスク - 表示項目の設定依存動作は明確

## 6) レビュアーチェックリスト（最小）
- [ ] 各設定による表示/非表示の動作確認
- [ ] 通貨表示の正確性確認
- [ ] ツールチップの表示確認
- [ ] バッジ表示の確認
- [ ] ヘッダーアクションの動作確認
- [ ] サブナビゲーションの遷移確認
