---
generated_at: 2025-12-26 18:46:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：297-受注一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：実際のルート設定との照合

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource/Pages/ListOrders.php`
- E-03: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php`
- E-04: `plugins/webkul/sales/src/Models/Order.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | モデルはOrder::classを使用 | E-01 ($model = Order::class) | ○ |
| C-02 | table関数はQuotationResource::tableを再利用 | E-01 (QuotationResource::table($table)) | ○ |
| C-03 | modifyQueryUsingでstate = SALEフィルター | E-01 | ○ |
| C-04 | form関数はQuotationResource::formを再利用 | E-01 | ○ |
| C-05 | infolist関数はQuotationResource::infolistを再利用 | E-01 | ○ |
| C-06 | ナビゲーションソートは2 | E-01 (navigationSort = 2) | ○ |
| C-07 | ナビゲーションアイコンはheroicon-o-shopping-bag | E-01 | ○ |
| C-08 | クラスターはOrders::class | E-01 | ○ |
| C-09 | recordTitleAttributeはname | E-01 | ○ |
| C-10 | ページ構成にindex, create, view, edit, invoices, deliveriesがある | E-01 (getPages) | ○ |
| C-11 | サブナビゲーションにManageInvoices, ManageDeliveriesがある | E-01 (getRecordSubNavigation) | ○ |
| C-12 | getModelLabelで多言語対応 | E-01 | ○ |
| C-13 | getNavigationLabelで多言語対応 | E-01 | ○ |
| C-14 | getEloquentQueryでorderByDesc('id') | E-01 | ○ |
| C-15 | 見積書一覧と同じカラム構成 | E-01, E-03 | ○ |
| C-16 | 見積書一覧と同じフィルター構成 | E-01, E-03 | ○ |
| C-17 | SoftDeletesを使用 | E-04 | ○ |
| C-18 | URL/ルーティングの詳細パス | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの完全なパス
  - 候補：Filamentパネル設定 / RouteServiceProvider

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - QuotationResourceを再利用しており、見積書一覧との整合性が保たれている
- 1: 低リスク - SALEステータスのフィルタリングは明確

## 6) レビュアーチェックリスト（最小）
- [ ] SALEステータスのレコードのみ表示されることを確認
- [ ] 見積書一覧との表示差異を確認
- [ ] サブナビゲーションの動作確認
- [ ] 削除アクションの動作確認
