---
generated_at: 2025-12-26 18:48:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：298-受注作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：実際のルート設定との照合

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource/Pages/CreateOrder.php`
- E-03: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php`
- E-04: `plugins/webkul/sales/src/Models/Order.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | form関数はQuotationResource::formを再利用 | E-01 (QuotationResource::form($schema)) | ○ |
| C-02 | 見積書作成画面と同じフォーム構成 | E-01, E-03 | ○ |
| C-03 | デフォルトステータスはDraft | E-03 (default(OrderState::DRAFT->value)) | ○ |
| C-04 | 顧客選択でcustomer sub_typeフィルター | E-03 | ○ |
| C-05 | 顧客選択時に担当者・支払条件自動設定 | E-03 | ○ |
| C-06 | 会社選択で通貨自動設定 | E-03 | ○ |
| C-07 | 受注番号は'SO/' + idで自動生成 | E-04 (updateName関数) | ○ |
| C-08 | sales_ordersテーブルに挿入 | E-04 ($table = 'sales_orders') | ○ |
| C-09 | sales_order_linesテーブルに明細挿入 | E-04 (lines hasMany) | ○ |
| C-10 | HasFactoryトレイトを使用 | E-04 | ○ |
| C-11 | ページルートは/create | E-01 (CreateOrder::route('/create')) | ○ |
| C-12 | ナビゲーションアイコンはheroicon-o-shopping-bag | E-01 | ○ |
| C-13 | クラスターはOrders::class | E-01 | ○ |
| C-14 | URL/ルーティングの詳細パス | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの完全なパス
  - 候補：Filamentパネル設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - QuotationResourceを再利用しており、見積書作成との整合性が保たれている
- 1: 低リスク - フォーム構成は見積書作成と同一

## 6) レビュアーチェックリスト（最小）
- [ ] フォーム動作が見積書作成と同じであることを確認
- [ ] 作成後のリダイレクト先を確認
- [ ] 初期ステータスがDraftであることを確認
