---
generated_at: 2025-12-26 18:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：299-受注編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **ヘッダーアクションの詳細**：EditOrder.phpのアクション確認
  2. **URL/ルーティング**：実際のルート設定との照合

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource/Pages/EditOrder.php`
- E-03: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php`
- E-04: `plugins/webkul/sales/src/Models/Order.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | form関数はQuotationResource::formを再利用 | E-01 | ○ |
| C-02 | 見積書編集画面と同じフォーム構成 | E-01, E-03 | ○ |
| C-03 | 顧客はロック時に非活性 | E-03 (disabled条件) | ○ |
| C-04 | 受注日はロック時に非活性 | E-03 (disabled条件) | ○ |
| C-05 | lockedフラグで編集制御 | E-04 (locked fillable) | ○ |
| C-06 | HasChatterトレイトを使用 | E-04 | ○ |
| C-07 | HasLogActivityトレイトを使用 | E-04 | ○ |
| C-08 | SoftDeletesを使用 | E-04 | ○ |
| C-09 | サブナビゲーションにManageInvoices, ManageDeliveriesがある | E-01 (getRecordSubNavigation) | ○ |
| C-10 | ページルートは/{record}/edit | E-01 | ○ |
| C-11 | 更新日時が記録される | E-04 | ○ |
| C-12 | amount_untaxed, amount_tax, amount_totalが計算される | E-04 | ○ |
| C-13 | sales_order_linesと関連 | E-04 (lines関数) | ○ |
| C-14 | クラスターはOrders::class | E-01 | ○ |
| C-15 | ヘッダーアクションの詳細 | **EditOrder.php確認必要** | △ |
| C-16 | URL/ルーティングの詳細パス | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- EditOrder.phpのヘッダーアクション定義
  - 候補：getHeaderActions関数
- URL/ルーティングの完全なパス
  - 候補：Filamentパネル設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - QuotationResourceを再利用しており、見積書編集との整合性が保たれている
- 1: 中リスク - ヘッダーアクションの詳細は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ロック状態での編集制限動作確認
- [ ] フォーム動作が見積書編集と同じであることを確認
- [ ] サブナビゲーションの遷移確認
- [ ] チャッター機能の動作確認
