---
generated_at: 2025-12-26 18:02:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-勘定科目編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/AccountResource/Pages/EditAccount.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/AccountResource.php`
- E-03: `plugins/webkul/accounts/src/Models/Account.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面クラスはEditRecordを継承 | E-01 | ○ |
| C-02 | 保存成功後にViewAccountへリダイレクト | E-01 | ○ |
| C-03 | 保存成功通知を表示 | E-01 | ○ |
| C-04 | ヘッダーにViewActionが存在 | E-01 | ○ |
| C-05 | ヘッダーにDeleteActionが存在 | E-01 | ○ |
| C-06 | 削除成功時に通知を表示 | E-01 | ○ |
| C-07 | フォームはAccountResource::formを使用 | E-02 | ○ |
| C-08 | URLは/{record}/edit形式 | E-02 | ○ |
| C-09 | フォームに必須項目code, nameが存在 | E-02 | ○ |
| C-10 | フォームにaccount_type項目が存在 | E-02 | ○ |
| C-11 | フォームに各種トグルが存在 | E-02 | ○ |
| C-12 | 科目タイプOFF_BALANCEで税非表示 | E-02 | ○ |
| C-13 | モデルはaccounts_accountsテーブル | E-03 | ○ |
| C-14 | 画面一覧でNo.3として登録 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく仕様のため、実装との整合性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] 編集時のバリデーションルール確認
- [ ] 関連テーブルの同期処理の動作確認
- [ ] 削除時の関連データ処理の確認
