---
generated_at: 2025-12-26 12:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：30-仕訳帳作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **権限による表示制御**：権限設定の詳細実装未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/JournalResource/Pages/CreateJournal.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/JournalResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行31）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がCreateRecord | E-01: CreateRecord継承 | ○ |
| C-02 | 保存後に詳細画面へリダイレクト | E-01: getRedirectUrl() | ○ |
| C-03 | 作成成功時に通知を表示 | E-01: getCreatedNotification() | ○ |
| C-04 | mutateFormDataBeforeCreateでcreator_id設定 | E-01: mutateFormDataBeforeCreate() | ○ |
| C-05 | invoice_reference_typeのデフォルト設定 | E-01: CommunicationType::INVOICE->value | ○ |
| C-06 | invoice_reference_modelのデフォルト設定 | E-01: CommunicationStandard::AUREUS->value | ○ |
| C-07 | 3カラムレイアウト | E-02: columns(3) | ○ |
| C-08 | 左側が2カラム幅 | E-02: columnSpan(['lg' => 2]) | ○ |
| C-09 | 右側が1カラム幅 | E-02: columnSpan(['lg' => 1]) | ○ |
| C-10 | 4つのタブ構成 | E-02: Tabs journal-entries, incoming, outgoing, advanced | ○ |
| C-11 | 種類に応じたrefund_order表示条件 | E-02: hidden(function (Get $get) { return ! in_array($get('type'), [SALE, PURCHASE]) }) | ○ |
| C-12 | 種類に応じたpayment_order表示条件 | E-02: hidden BANK/CASH/CREDIT_CARD | ○ |
| C-13 | 銀行口座フィールドセットの表示条件 | E-02: visible(BANK) | ○ |
| C-14 | 入金/出金タブの表示条件 | E-02: visible(BANK/CASH/CREDIT_CARD) | ○ |
| C-15 | 支払コミュニケーションフィールドセットの表示条件 | E-02: visible(SALE) | ○ |
| C-16 | 会社選択が無効化 | E-02: company_id disabled() | ○ |
| C-17 | 会社のデフォルト値 | E-02: default(Auth::user()->default_company_id) | ○ |
| C-18 | カラーピッカーがHEX形式 | E-02: ColorPicker hexColor() | ○ |
| C-19 | タブがクエリストリングに永続化 | E-02: persistTabInQueryString() | ○ |
| C-20 | ルーティングが/create | E-02: getPages() 'create' route | ○ |
| C-21 | 画面一覧に登録されている | E-03: No.30 仕訳帳作成 | ○ |
| C-22 | 権限による表示制御の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限設定の詳細はFilamentの権限設定またはポリシークラスの確認が必要
  - 候補：`JournalPolicy.php` / `Filament Shield設定`
- journalsテーブルのマイグレーション定義
- JournalType, CommunicationType, CommunicationStandard enumの完全な定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム項目定義（ソースコードから明確）
- 0: 低リスク - 条件付き表示ロジック（ソースコードから明確）
- 0: 低リスク - レイアウト構成（ソースコードから明確）
- 1: 中リスク - 権限制御の詳細（別ファイル参照必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限設定の実装内容を確認
- [ ] 多言語ファイル（accounts::filament/resources/journal/pages/create-journal）の存在確認
- [ ] journalsテーブルのマイグレーション定義との整合性確認
- [ ] JournalType, CommunicationType, CommunicationStandard enumの定義確認
