---
generated_at: 2025-12-26 18:52:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：300-受注詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **ヘッダーアクションの詳細**：ViewOrder.phpのアクション確認
  2. **URL/ルーティング**：実際のルート設定との照合

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/OrderResource/Pages/ViewOrder.php`
- E-03: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/QuotationResource.php`
- E-04: `plugins/webkul/sales/src/Models/Order.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | infolist関数はQuotationResource::infolistを再利用 | E-01 | ○ |
| C-02 | 見積書詳細画面と同じ表示構成 | E-01, E-03 | ○ |
| C-03 | ステータスはバッジ表示 | E-03 (TextEntry->badge()) | ○ |
| C-04 | コンパクトセクションでステータス表示 | E-03 (Section->compact()) | ○ |
| C-05 | 受注番号は太字・大サイズ | E-03 (weight, size) | ○ |
| C-06 | アイコン付きテキストエントリー | E-03 (icon()) | ○ |
| C-07 | RepeatableEntryで商品明細表示 | E-03 | ○ |
| C-08 | カラムマネージャーで表示カスタマイズ | E-03 | ○ |
| C-09 | 設定による表示/非表示制御 | E-03 (visible条件) | ○ |
| C-10 | 通貨はレコードごとのcurrency.code | E-03 | ○ |
| C-11 | HasChatterトレイトを使用 | E-04 | ○ |
| C-12 | サブナビゲーションにManageInvoices, ManageDeliveriesがある | E-01 (getRecordSubNavigation) | ○ |
| C-13 | ページルートは/{record} | E-01 | ○ |
| C-14 | クラスターはOrders::class | E-01 | ○ |
| C-15 | ヘッダーアクションの詳細 | **ViewOrder.php確認必要** | △ |
| C-16 | URL/ルーティングの詳細パス | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- ViewOrder.phpのヘッダーアクション定義
  - 候補：getHeaderActions関数
- URL/ルーティングの完全なパス
  - 候補：Filamentパネル設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - QuotationResourceを再利用しており、見積書詳細との整合性が保たれている
- 1: 低リスク - Infolist構造は正確に記述されている

## 6) レビュアーチェックリスト（最小）
- [ ] 表示動作が見積書詳細と同じであることを確認
- [ ] サブナビゲーションの遷移確認
- [ ] 請求書管理・配送管理画面への遷移確認
- [ ] チャッター機能の動作確認
- [ ] ヘッダーアクションの動作確認
