---
generated_at: 2025-12-26 18:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：301-顧客一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **画面遷移の遷移元画面**：具体的なリンク元のコード確認が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/CustomerResource.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/CustomerResource/Pages/ListCustomers.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
- E-04: `plugins/webkul/partners/src/Filament/Resources/PartnerResource/Pages/ListPartners.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CustomerResourceはBaseCustomerResourceを継承している | E-01 (line 18) | ○ |
| C-02 | モデルはPartner::classを使用 | E-01 (line 20) | ○ |
| C-03 | ナビゲーションアイコンはheroicon-o-users | E-01 (line 22) | ○ |
| C-04 | Ordersクラスターに属する | E-01 (line 26) | ○ |
| C-05 | ListCustomersはBaseListCustomersを継承 | E-02 (line 10) | ○ |
| C-06 | ヘッダーにCreateActionがある | E-02 (line 22-24) | ○ |
| C-07 | テーブルはカードグリッドレイアウト（sm:1, md:2, xl:3） | E-01 (line 43-47) | ○ |
| C-08 | プリセットビューに個人/法人/アーカイブがある | E-04 (line 34-51) | ○ |
| C-09 | 表示カラムにavatar, name, parent, job_title, email, phone, tagsがある | E-03 (line 319-381) | ○ |
| C-10 | フィルタはQueryBuilderを使用しモーダル形式 | E-03 (line 396-495) | ○ |
| C-11 | ソフトデリート・復元・完全削除アクションがある | E-03 (line 501-545) | ○ |
| C-12 | 一括削除・復元・完全削除アクションがある | E-03 (line 547-582) | ○ |
| C-13 | ページネーションは16/32/64/all | E-03 (line 594-598) | ○ |
| C-14 | 顧客詳細・編集・連絡先・住所・銀行口座管理のサブナビゲーションがある | E-01 (line 51-59) | ○ |
| C-15 | ルーティングにindex/create/view/edit等がある | E-01 (line 63-73) | ○ |
| C-16 | 関連機能FN-SALES-017〜020が定義されている | E-07 | ○ |
| C-17 | 画面No.301として画面一覧に登録されている | E-05 (line 302) | ○ |
| C-18 | 販売ダッシュボード等から遷移してくる | E-06 | △ |

## 4) 不足情報（Unknown / Missing）
- 遷移元画面（販売ダッシュボード、見積書一覧、受注一覧からのリンク）については画面遷移図から推測したが、具体的なリンク実装コードは未確認
  - 候補：ダッシュボードのナビゲーション設定 / サイドバー構成ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] CustomerResourceの継承関係が正しいか確認
- [ ] グリッドレイアウトの列数設定が実際の表示と一致するか確認
- [ ] プリセットビューのフィルタ条件が正しいか確認
- [ ] 権限設定（Filament Shield）の動作を確認
