---
generated_at: 2025-12-26 18:42:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：302-顧客作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/CustomerResource/Pages/CreateCustomer.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/PartnerResource/Pages/CreatePartner.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateCustomerはBaseCreateCustomerを継承 | E-01 (line 9) | ○ |
| C-02 | mutateFormDataBeforeCreateでsub_type='customer'を設定 | E-01 (line 27-33) | ○ |
| C-03 | 保存後はview画面へリダイレクト | E-02 (line 23-25) | ○ |
| C-04 | フォームにaccount_typeラジオボタンがある | E-03 (line 72-85) | ○ |
| C-05 | nameフィールドは必須で最大255文字 | E-03 (line 86-92) | ○ |
| C-06 | parent_idは個人の場合のみ表示 | E-03 (line 93-103) | ○ |
| C-07 | avatarはファイルアップロードで画像エディタ付き | E-03 (line 137-145) | ○ |
| C-08 | emailは一意制約がある | E-03 (line 166-170) | ○ |
| C-09 | websiteはURL形式 | E-03 (line 171-174) | ○ |
| C-10 | country_id変更でstate_idがリセットされる | E-03 (line 228-237) | ○ |
| C-11 | タグは複数選択可能 | E-03 (line 193-212) | ○ |
| C-12 | 敬称のインライン作成が可能 | E-03 (line 175-192) | ○ |
| C-13 | 住所フィールドセットがある | E-03 (line 214-272) | ○ |
| C-14 | 販売・購買タブにuser_id/company_registry/reference/industry_idがある | E-03 (line 277-308) | ○ |
| C-15 | 画面No.302として画面一覧に登録されている | E-04 (line 303) | ○ |
| C-16 | 関連機能FN-SALES-018が定義されている | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] sub_type='customer'が正しく設定されるか動作確認
- [ ] 所属会社選択が法人のみに絞られるか確認
- [ ] メールアドレスの一意制約が正しく動作するか確認
- [ ] 国選択時の州リセットが正しく動作するか確認
