---
generated_at: 2025-12-26 18:46:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：304-顧客詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/CustomerResource/Pages/ViewCustomer.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Orders/Resources/CustomerResource.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewCustomerはBaseViewCustomerを継承 | E-01 (line 8) | ○ |
| C-02 | URLは/{record}形式 | E-02 (line 67) | ○ |
| C-03 | サブナビゲーションに5つの画面がある | E-02 (line 51-59) | ○ |
| C-04 | infolistはPartnerResourceで定義 | E-03 (line 602-745) | ○ |
| C-05 | account_typeはバッジ表示でprimary色 | E-03 (line 612-614) | ○ |
| C-06 | nameは太字・大きめフォントで表示 | E-03 (line 616-618) | ○ |
| C-07 | parent.nameは個人の場合のみ表示 | E-03 (line 620-622) | ○ |
| C-08 | avatarは円形100x100pxで表示 | E-03 (line 627-629) | ○ |
| C-09 | 値未設定時はプレースホルダー「—」が表示される | E-03 (line 636-638等) | ○ |
| C-10 | 電話番号にはheroicon-o-phoneアイコンが付く | E-03 (line 644-647) | ○ |
| C-11 | タグはカラー付きバッジで表示される | E-03 (line 668-681) | ○ |
| C-12 | 住所フィールドセットがある | E-03 (line 684-709) | ○ |
| C-13 | 販売・購買タブにuser/company_registry/reference/industryがある | E-03 (line 712-740) | ○ |
| C-14 | 画面No.304として画面一覧に登録されている | E-04 (line 305) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] サブナビゲーションが正しく表示されるか確認
- [ ] 未設定項目のプレースホルダー表示を確認
- [ ] タグのカラー表示が正しいか確認
- [ ] アバター画像の円形表示を確認
