---
generated_at: 2025-12-26 18:54:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：308-チーム一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Configuration/Resources/TeamResource.php`
- E-02: `plugins/webkul/sales/src/Filament/Clusters/Configuration/Resources/TeamResource/Pages/ListTeams.php`
- E-03: `plugins/webkul/sales/src/Models/Team.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | モデルはTeam::classを使用 | E-01 (line 46) | ○ |
| C-02 | ナビゲーションアイコンはheroicon-o-users | E-01 (line 48) | ○ |
| C-03 | Configurationクラスターに属する | E-01 (line 50) | ○ |
| C-04 | shouldRegisterNavigation=false | E-01 (line 52) | ○ |
| C-05 | テーブルにid/company/user/color/createdBy/name/is_active/invoiced_target/created_at/updated_at列がある | E-01 (line 119-156) | ○ |
| C-06 | QueryBuilderフィルタで名前/チームリーダー/会社/作成者/作成日/更新日がある | E-01 (line 158-195) | ○ |
| C-07 | グループ化でname/company/user/created_at/updated_atがある | E-01 (line 197-214) | ○ |
| C-08 | 行アクションにView/Edit/Delete/Restore/ForceDeleteがある | E-01 (line 215-239) | ○ |
| C-09 | 一括アクションにRestore/Delete/ForceDeleteがある | E-01 (line 240-264) | ○ |
| C-10 | reorderable('sort', 'desc')で並び替え可能 | E-01 (line 265) | ○ |
| C-11 | ListTeamsにCreateActionがある | E-02 (line 17-19) | ○ |
| C-12 | タブにall/archivedがある | E-02 (line 23-30) | ○ |
| C-13 | タブにTeam::count()でバッジ表示 | E-02 (line 27, 29) | ○ |
| C-14 | TeamモデルはSoftDeletesを使用 | E-03 (line 18) | ○ |
| C-15 | TeamモデルはSortableTraitを使用 | E-03 (line 18) | ○ |
| C-16 | 画面No.308として画面一覧に登録されている | E-04 (line 309) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ドラッグ＆ドロップでの並び替えが正しく動作するか確認
- [ ] タブのバッジ件数が正しく表示されるか確認
- [ ] アーカイブ済みタブで復元・完全削除が動作するか確認
