---
generated_at: 2025-12-26 18:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：31-仕訳帳編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **メッセージ内容**：多言語ファイルの実際の内容未確認
  2. **権限制御の詳細**：具体的な権限チェック実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/JournalResource/Pages/EditJournal.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/JournalResource.php`
- E-03: `plugins/webkul/accounts/src/Models/Journal.php`
- E-04: `plugins/webkul/accounts/src/Enums/JournalType.php`（参照のみ、内容未読）
- E-05: `plugins/webkul/accounts/src/Enums/CommunicationType.php`（参照のみ、内容未読）
- E-06: `plugins/webkul/accounts/src/Enums/CommunicationStandard.php`（参照のみ、内容未読）
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「仕訳帳編集」 | E-07 | ○ |
| C-02 | URLパターンは `/journals/{record}/edit` | E-02 (getPages) | ○ |
| C-03 | EditRecordを継承 | E-01 | ○ |
| C-04 | ヘッダーにViewActionとDeleteActionがある | E-01 (getHeaderActions) | ○ |
| C-05 | 保存後は詳細画面へリダイレクト | E-01 (getRedirectUrl) | ○ |
| C-06 | 保存時に成功通知を表示 | E-01 (getSavedNotification) | ○ |
| C-07 | mutateFormDataBeforeSaveでcreator_idを設定 | E-01 | ○ |
| C-08 | invoice_reference_typeのデフォルト値設定 | E-01 | ○ |
| C-09 | invoice_reference_modelのデフォルト値設定 | E-01 | ○ |
| C-10 | フォームに名前フィールドがある（必須） | E-02 (form) | ○ |
| C-11 | フォームにタイプフィールドがある（必須、live） | E-02 (form) | ○ |
| C-12 | 会社フィールドがdisabledで表示される | E-02 (form) | ○ |
| C-13 | タイプがsale/purchaseの時refund_orderを表示 | E-02 (form, hidden条件) | ○ |
| C-14 | タイプがbank/cash/credit_cardの時payment_orderを表示 | E-02 (form, hidden条件) | ○ |
| C-15 | タイプがbankの時bank_account_idを表示 | E-02 (form, visible条件) | ○ |
| C-16 | タブはpersistTabInQueryStringで永続化 | E-02 (form) | ○ |
| C-17 | 仕訳エントリ、入金、出金、詳細設定の4タブがある | E-02 (form, Tab) | ○ |
| C-18 | 入金/出金タブはbank/cash/credit_cardタイプで表示 | E-02 (form, visible条件) | ○ |
| C-19 | 許可勘定科目は複数選択可能 | E-02 (form, multiple) | ○ |
| C-20 | 請求書参照設定はsaleタイプのみ表示 | E-02 (form, visible条件) | ○ |
| C-21 | テーブル名はaccounts_journals | E-03 ($table) | ○ |
| C-22 | 許可勘定科目はaccounts_journal_accountsテーブルで管理 | E-03 (allowedAccounts) | ○ |
| C-23 | 通貨はリレーションで取得 | E-02, E-03 | ○ |
| C-24 | 銀行口座はリレーションで取得 | E-02, E-03 | ○ |
| C-25 | JournalTypeにsale, purchase, cash, bank, credit_card, generalがある | E-02 (JournalType参照) | ○ |
| C-26 | 色フィールドは16進カラー形式 | E-02 (ColorPicker, hexColor) | ○ |
| C-27 | 通知メッセージは多言語ファイルから取得 | E-01, E-02 (言語キー使用) | △ |
| C-28 | 権限に基づくアクセス制御がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 多言語ファイル（`accounts::filament/resources/journal/pages/edit-journal.*`）の実際の内容
  - 候補：`lang/ja/filament/resources/journal/pages/edit-journal.php` / 類似パス
- 権限設定の具体的な実装（Policyクラスまたはauthorize設定）
  - 候補：`JournalPolicy.php` / `filament.php`設定 / リソースのcanメソッド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構造とDB更新処理
- 1: 中リスク - メッセージ内容（多言語対応の実装詳細）
- 0: 低リスク - 画面遷移とリダイレクト

## 6) レビュアーチェックリスト（最小）
- [ ] JournalType列挙型の実際の値を確認（sale, purchase等の実際の文字列値）
- [ ] 多言語ファイルの通知メッセージ内容を確認
- [ ] 権限設定（誰がこの画面を操作できるか）の実装を確認
- [ ] CommunicationType, CommunicationStandard列挙型の値を確認
