---
generated_at: 2025-12-26 18:58:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：310-価格設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Settings/Pages/ManagePricing.php`
- E-02: `plugins/webkul/sales/src/Settings/PriceSettings.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManagePricingはSettingsPageを継承 | E-01 (line 12) | ○ |
| C-02 | HasPageShieldトレイトを使用 | E-01 (line 14) | ○ |
| C-03 | ナビゲーションアイコンはheroicon-o-currency-dollar | E-01 (line 16) | ○ |
| C-04 | URLスラッグはsale/manage-pricing | E-01 (line 18) | ○ |
| C-05 | ナビゲーショングループはSales | E-01 (line 20) | ○ |
| C-06 | ナビゲーションソート順は2 | E-01 (line 22) | ○ |
| C-07 | 設定クラスはPriceSettings | E-01 (line 24) | ○ |
| C-08 | Settingsクラスターに属する | E-01 (line 26) | ○ |
| C-09 | フォームにenable_discountトグルがある | E-01 (line 49-51) | ○ |
| C-10 | フォームにenable_marginトグルがある | E-01 (line 52-54) | ○ |
| C-11 | PriceSettingsのグループはsales_price | E-02 (line 13-15) | ○ |
| C-12 | 画面No.310として画面一覧に登録されている | E-03 (line 311) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] トグル設定が正しく保存されるか確認
- [ ] enable_discount設定が見積書/注文画面に反映されるか確認
- [ ] enable_margin設定が注文明細に反映されるか確認
- [ ] HasPageShieldによる権限制御が動作するか確認
