---
generated_at: 2025-12-26 19:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：311-見積書・注文設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細動作**：HasPageShieldの具体的な挙動確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Settings/Pages/ManageQuotationAndOrder.php`
- E-02: `plugins/webkul/sales/src/Settings/QuotationAndOrderSettings.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.311の行）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/sale/manage-quotation-and-order` | E-01 (L19: `protected static ?string $slug = 'sale/manage-quotation-and-order'`) | ○ |
| C-02 | ナビゲーショングループは「Sales」 | E-01 (L21: `protected static string\|\UnitEnum\|null $navigationGroup = 'Sales'`) | ○ |
| C-03 | ナビゲーションソート順は2 | E-01 (L23: `protected static ?int $navigationSort = 2`) | ○ |
| C-04 | 設定クラスはQuotationAndOrderSettings | E-01 (L25: `protected static string $settings = QuotationAndOrderSettings::class`) | ○ |
| C-05 | Settingsクラスターに属する | E-01 (L27: `protected static ?string $cluster = Settings::class`) | ○ |
| C-06 | HasPageShieldトレイト使用 | E-01 (L15: `use HasPageShield`) | ○ |
| C-07 | アイコンはheroicon-o-shopping-cart | E-01 (L17: `protected static string\|\BackedEnum\|null $navigationIcon = 'heroicon-o-shopping-cart'`) | ○ |
| C-08 | default_quotation_validityフィールド存在 | E-01 (L50-57), E-02 (L9) | ○ |
| C-09 | enable_lock_confirm_salesフィールド存在 | E-01 (L58-60), E-02 (L11) | ○ |
| C-10 | 有効日数のデフォルト値は30 | E-01 (L55: `->default(30)`) | ○ |
| C-11 | 有効日数は必須入力 | E-01 (L51: `->required()`) | ○ |
| C-12 | 有効日数は数値型 | E-01 (L53: `->numeric()`) | ○ |
| C-13 | 有効日数の最小値は0 | E-01 (L52: `->minValue(0)`) | ○ |
| C-14 | 有効日数にsuffix「日」表示 | E-01 (L54: `->suffix(...)`) | ○ |
| C-15 | 設定グループ名は「sales_quotation_and_orders」 | E-02 (L14-16: `return 'sales_quotation_and_orders'`) | ○ |
| C-16 | カテゴリは「Sales（販売）」 | E-03（画面一覧.csvの該当行） | ○ |
| C-17 | 画面名は「見積書・注文設定」 | E-03（画面一覧.csvの該当行） | ○ |
| C-18 | 具体的なエラーメッセージ文言 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- メッセージ仕様の具体的な文言については、言語ファイル（`sales::filament/clusters/settings/pages/manage-quotation-and-order.*`）の内容確認が必要
  - 候補：langディレクトリ / 翻訳ファイル / config設定

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全体的にソースコードとの整合性が高い
- 設定保存の成功・失敗メッセージはFilament標準の動作に依存

## 6) レビュアーチェックリスト（最小）
- [ ] 権限設定（HasPageShield）の実際の動作確認
- [ ] 設定保存後の反映確認（見積作成時のデフォルト値）
- [ ] 言語ファイルでのメッセージ内容確認
