---
generated_at: 2025-12-26 19:02:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：313-請求書設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **InvoicePolicy Enumの選択肢詳細**：Enumファイルの確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/sales/src/Filament/Clusters/Settings/Pages/ManageInvoice.php`
- E-02: `plugins/webkul/sales/src/Settings/InvoiceSettings.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.313の行）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/sale/manage-invoicing` | E-01 (L19: `protected static ?string $slug = 'sale/manage-invoicing'`) | ○ |
| C-02 | ナビゲーショングループは「Sales」 | E-01 (L21: `protected static string\|\UnitEnum\|null $navigationGroup = 'Sales'`) | ○ |
| C-03 | ナビゲーションソート順は2 | E-01 (L23: `protected static ?int $navigationSort = 2`) | ○ |
| C-04 | 設定クラスはInvoiceSettings | E-01 (L25: `protected static string $settings = InvoiceSettings::class`) | ○ |
| C-05 | Settingsクラスターに属する | E-01 (L27: `protected static ?string $cluster = Settings::class`) | ○ |
| C-06 | HasPageShieldトレイト使用 | E-01 (L15: `use HasPageShield`) | ○ |
| C-07 | アイコンはheroicon-o-document-text | E-01 (L17: `protected static string\|\BackedEnum\|null $navigationIcon = 'heroicon-o-document-text'`) | ○ |
| C-08 | invoice_policyフィールド存在 | E-01 (L50-55), E-02 (L10) | ○ |
| C-09 | InvoicePolicyはEnum型 | E-01 (L51: `->options(InvoicePolicy::class)`), E-02 (L10) | ○ |
| C-10 | デフォルト値は'delivery' | E-01 (L52: `->default('delivery')`) | ○ |
| C-11 | 設定グループ名は「sales_invoicing」 | E-02 (L12-14: `return 'sales_invoicing'`) | ○ |
| C-12 | Radio入力コンポーネント使用 | E-01 (L50: `Radio::make('invoice_policy')`) | ○ |
| C-13 | カテゴリは「Sales（販売）」 | E-03（画面一覧.csvの該当行） | ○ |
| C-14 | 画面名は「請求書設定」 | E-03（画面一覧.csvの該当行） | ○ |
| C-15 | InvoicePolicy Enumの具体的な選択肢（order/delivery） | **根拠なし** - Enumファイル未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- InvoicePolicy Enumの詳細（選択肢とラベル）
  - 候補：`plugins/webkul/invoice/src/Enums/InvoicePolicy.php`
- 言語ファイルでの表示ラベル確認

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 主要な構造はソースコードにより裏付けられています
- InvoicePolicy Enumの選択肢名は推定値のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] InvoicePolicy Enumファイルで選択肢を確認
- [ ] 請求ポリシー変更時の既存データへの影響確認
- [ ] 言語ファイルでのラベル表示内容確認
