---
generated_at: 2025-12-26 19:03:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：314-ユーザー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **具体的なメッセージ文言**：言語ファイルでの確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/security/src/Filament/Resources/UserResource.php`
- E-02: `plugins/webkul/security/src/Filament/Resources/UserResource/Pages/ListUsers.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.314の行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（SCR-SEC-001）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UserモデルはUser::class | E-01 (L49: `protected static ?string $model = User::class`) | ○ |
| C-02 | navigationSortは4 | E-01 (L51: `protected static ?int $navigationSort = 4`) | ○ |
| C-03 | グローバル検索は名前とメール | E-01 (L63-66: `getGloballySearchableAttributes`) | ○ |
| C-04 | フォームにname, email, password項目 | E-01 (L86-109: formメソッド内) | ○ |
| C-05 | roles, resource_permission, teams選択 | E-01 (L115-132: フォーム定義) | ○ |
| C-06 | アバター画像アップロード | E-01 (L142-148: FileUpload) | ○ |
| C-07 | is_activeトグル | E-01 (L159-161: Toggle) | ○ |
| C-08 | 許可会社・デフォルト会社選択 | E-01 (L166-212: マルチカンパニーセクション) | ○ |
| C-09 | テーブルカラム: avatar, name, email等 | E-01 (L227-268: テーブルカラム定義) | ○ |
| C-10 | カラムのソート・検索機能 | E-01 (L233-251: searchable/sortable) | ○ |
| C-11 | フィルタ: resource_permission, companies, teams, roles | E-01 (L270-300: フィルタ定義) | ○ |
| C-12 | View, Edit, Delete, Restoreアクション | E-01 (L303-330: recordActions) | ○ |
| C-13 | BulkDelete, ForceDeleteBulkAction | E-01 (L333-366: toolbarActions) | ○ |
| C-14 | canDeleteUser検証 | E-01 (L480-483: is_defaultチェック) | ○ |
| C-15 | デフォルトソートはcreated_at DESC | E-01 (L369: `->defaultSort('created_at', 'desc')`) | ○ |
| C-16 | タブ: all, archived | E-02 (L23-33: getTabs) | ○ |
| C-17 | allタブはUser::count() | E-02 (L26-27) | ○ |
| C-18 | archivedタブはonlyTrashed | E-02 (L28-32) | ○ |
| C-19 | CreateActionヘッダー | E-02 (L39-41) | ○ |
| C-20 | inviteUserアクション | E-02 (L42-84) | ○ |
| C-21 | 招待はenable_user_invitation設定で制御 | E-02 (L47: `visible(fn (UserSettings $userSettings) => $userSettings->enable_user_invitation)`) | ○ |
| C-22 | 招待メール送信処理 | E-02 (L54-83: action内) | ○ |
| C-23 | default_company_id未設定時エラー | E-02 (L55-63) | ○ |
| C-24 | Invitation作成とメール送信 | E-02 (L65-82) | ○ |
| C-25 | ページルート: index, create, edit, view | E-01 (L485-492: getPages) | ○ |
| C-26 | reorderableColumns有効 | E-01 (L225: `->reorderableColumns()`) | ○ |
| C-27 | columnManagerColumns(2) | E-01 (L226: `->columnManagerColumns(2)`) | ○ |
| C-28 | 具体的なメッセージ文言（日本語） | **根拠なし** - 言語ファイル未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- 言語ファイル（`security::filament/resources/user.*`）の具体的な内容
  - 候補：`plugins/webkul/security/resources/lang`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 機能実装はソースコードで十分に裏付けられています
- メッセージ文言のみ言語ファイル確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 言語ファイルでのメッセージ内容確認
- [ ] ユーザー招待機能の動作確認
- [ ] デフォルトユーザー（is_default）の識別方法確認
