---
generated_at: 2025-12-26 19:06:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：317-ユーザー詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 該当なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/security/src/Filament/Resources/UserResource.php`
- E-02: `plugins/webkul/security/src/Filament/Resources/UserResource/Pages/ViewUsers.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.317の行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（FN-SEC-004）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewRecordを継承 | E-02 (L8: `extends ViewRecord`) | ○ |
| C-02 | UserResourceを使用 | E-02 (L14: `protected static string $resource = UserResource::class`) | ○ |
| C-03 | EditAction存在 | E-02 (L19: `EditAction::make()`) | ○ |
| C-04 | DeleteAction存在 | E-02 (L20-27) | ○ |
| C-05 | DeleteはcanDeleteUserで制御 | E-02 (L21: `visible(fn (User $record) => self::getResource()::canDeleteUser($record))`) | ○ |
| C-06 | 削除成功通知あり | E-02 (L22-26: `successNotification`) | ○ |
| C-07 | infolistでname表示 | E-01 (L396-402: `TextEntry::make('name')`) | ○ |
| C-08 | nameにheroicon-o-userアイコン | E-01 (L397: `->icon('heroicon-o-user')`) | ○ |
| C-09 | emailにheroicon-o-envelopeアイコン | E-01 (L404: `->icon('heroicon-o-envelope')`) | ○ |
| C-10 | languageにheroicon-o-languageアイコン | E-01 (L408: `->icon('heroicon-o-language')`) | ○ |
| C-11 | rolesにheroicon-o-keyアイコン | E-01 (L417: `->icon('heroicon-o-key')`) | ○ |
| C-12 | teamsにheroicon-o-user-groupアイコン | E-01 (L424: `->icon('heroicon-o-user-group')`) | ○ |
| C-13 | resource_permissionに動的アイコン | E-01 (L430-436: 権限タイプ別アイコン定義) | ○ |
| C-14 | アバター円形表示 | E-01 (L450: `->circular()`) | ○ |
| C-15 | allowedCompaniesにheroicon-o-building-office | E-01 (L457: `->icon('heroicon-o-building-office')`) | ○ |
| C-16 | defaultCompanyにheroicon-o-building-office-2 | E-01 (L463: `->icon('heroicon-o-building-office-2')`) | ○ |
| C-17 | is_activeはbooleanアイコン表示 | E-01 (L470-472: `IconEntry...->boolean()`) | ○ |
| C-18 | canDeleteUserはis_defaultチェック | E-01 (L480-483) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。ソースコードから十分な情報が取得できています。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全ての主張がソースコードにより裏付けられています

## 6) レビュアーチェックリスト（最小）
- [ ] Infolist表示の動作確認
- [ ] 削除アクションの表示条件確認
- [ ] デフォルトユーザー識別の動作確認
