---
generated_at: 2025-12-26 18:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：32-仕訳帳詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **外部キー制約違反時の挙動**：削除時の制約エラー処理の実装詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/JournalResource/Pages/ViewJournal.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/JournalResource.php`
- E-03: `plugins/webkul/accounts/src/Models/Journal.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「仕訳帳詳細」 | E-04 | ○ |
| C-02 | URLパターンは `/journals/{record}` | E-02 (getPages) | ○ |
| C-03 | ViewRecordを継承 | E-01 | ○ |
| C-04 | ヘッダーにEditActionとDeleteActionがある | E-01 (getHeaderActions) | ○ |
| C-05 | 削除成功時に通知を表示 | E-01 (successNotification) | ○ |
| C-06 | infolistでタブ表示を行う | E-02 (infolist) | ○ |
| C-07 | 3カラムグリッドレイアウト | E-02 (Grid::make(['default' => 3])) | ○ |
| C-08 | 仕訳エントリ、入金、出金、詳細設定の4タブ構成 | E-02 (infolist, Tab) | ○ |
| C-09 | 入金/出金タブはbank/cash/credit_cardで表示 | E-02 (visible条件) | ○ |
| C-10 | refund_orderはsale/purchaseタイプで表示 | E-02 (visible条件) | ○ |
| C-11 | payment_orderはbank/cash/credit_cardで表示 | E-02 (visible条件) | ○ |
| C-12 | 銀行口座セクションはbankタイプで表示 | E-02 (visible条件) | ○ |
| C-13 | 請求書参照設定はsaleタイプで表示 | E-02 (visible条件) | ○ |
| C-14 | nameにdocument-textアイコン | E-02 (icon) | ○ |
| C-15 | typeにtagアイコン | E-02 (icon) | ○ |
| C-16 | companyにbuilding-officeアイコン | E-02 (icon) | ○ |
| C-17 | boolean項目はIconEntryで表示 | E-02 (IconEntry) | ○ |
| C-18 | 色はColorEntryで表示 | E-02 (ColorEntry) | ○ |
| C-19 | 許可勘定科目はlistWithLineBreaksで表示 | E-02 (listWithLineBreaks) | ○ |
| C-20 | リレーションノートはmarkdown形式 | E-02 (markdown) | ○ |
| C-21 | プレースホルダーは「-」 | E-02 (placeholder('-')) | ○ |
| C-22 | テーブル名はaccounts_journals | E-03 ($table) | ○ |
| C-23 | 多言語通知メッセージを使用 | E-01 (言語キー使用) | ○ |
| C-24 | 外部キー制約違反時にエラー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 外部キー制約違反時のエラーハンドリング実装
  - 候補：`DeleteAction`のカスタムエラーハンドラ / DBマイグレーションの制約設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 表示項目とレイアウト
- 0: 低リスク - タブの表示条件
- 1: 中リスク - 削除時のエラーハンドリング

## 6) レビュアーチェックリスト（最小）
- [ ] 多言語ファイルの削除通知メッセージ内容を確認
- [ ] 仕訳帳が他テーブルで参照されている場合の削除動作を確認
- [ ] 各タブの表示条件が正しく機能するか実機確認
