---
generated_at: 2025-12-26 19:02:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：322-会社一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **i18nメッセージ内容**：実際のメッセージテキストは言語ファイル参照が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/security/src/Filament/Resources/CompanyResource/Pages/ListCompanies.php`
- E-02: `plugins/webkul/security/src/Filament/Resources/CompanyResource.php`
- E-03: `plugins/webkul/support/src/Models/Company.php`
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が一覧表示 | E-01（ListRecordsを継承） | ○ |
| C-02 | 全件/アーカイブのタブ切替 | E-01（getTabs()） | ○ |
| C-03 | 件数バッジ表示 | E-01（Company::count()） | ○ |
| C-04 | 新規作成ボタン | E-01（CreateAction::make()） | ○ |
| C-05 | HasTableViewsトレイト使用 | E-01（use HasTableViews） | ○ |
| C-06 | テーブルカラム定義 | E-02（table()メソッド） | ○ |
| C-07 | 画像カラム（avatar） | E-02（ImageColumn） | ○ |
| C-08 | グループ化設定 | E-02（groups配列） | ○ |
| C-09 | フィルタ設定（ステータス・国） | E-02（filters配列） | ○ |
| C-10 | 行アクション（View/Edit/Delete/Restore） | E-02（recordActions） | ○ |
| C-11 | 一括アクション | E-02（toolbarActions） | ○ |
| C-12 | デフォルト会社削除制限 | E-02（hidden条件、checkIfRecordIsSelectableUsing） | ○ |
| C-13 | creator_idフィルタ | E-02（modifyQueryUsing） | ○ |
| C-14 | parent_id IS NULLフィルタ | E-02（modifyQueryUsing） | ○ |
| C-15 | 並び替え対応 | E-02（reorderable('sort')） | ○ |
| C-16 | Companyモデルのfillable | E-03（$fillable定義） | ○ |
| C-17 | パートナー自動作成 | E-03（creating/savedイベント） | ○ |
| C-18 | メッセージの具体的内容 | **根拠なし（言語ファイル要確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- 通知メッセージの具体的なテキストは言語ファイル（security::filament/resources/company.*）を確認する必要あり
  - 候補：plugins/webkul/security/resources/lang/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから主要機能を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 言語ファイルでメッセージ内容を確認
- [ ] 実際の画面でフィルタ・検索動作を確認
