---
generated_at: 2025-12-26 19:06:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：324-会社編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/security/src/Filament/Resources/CompanyResource/Pages/EditCompany.php`
- E-02: `plugins/webkul/security/src/Filament/Resources/CompanyResource.php`
- E-03: `plugins/webkul/support/src/Models/Company.php`
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が編集 | E-01（EditRecordを継承） | ○ |
| C-02 | 保存後に詳細画面へリダイレクト | E-01（getRedirectUrl()） | ○ |
| C-03 | 成功通知表示 | E-01（getSavedNotification()） | ○ |
| C-04 | creator_id更新 | E-01（mutateFormDataBeforeSave()） | ○ |
| C-05 | 表示ボタン | E-01（ViewAction::make()） | ○ |
| C-06 | 削除ボタン | E-01（DeleteAction::make()） | ○ |
| C-07 | デフォルト会社判定 | E-01（User::where('default_company_id', $this->record->id)->exists()） | ○ |
| C-08 | 削除成功通知 | E-01（successNotification()） | ○ |
| C-09 | フォーム共通化 | E-02（form()メソッド） | ○ |
| C-10 | 3カラムレイアウト | E-02（columns(3)） | ○ |
| C-11 | 国選択時の都道府県連動 | E-02（afterStateUpdated） | ○ |
| C-12 | パートナー自動更新 | E-03（static::saved()イベント） | ○ |
| C-13 | ルーティング定義 | E-02（getPages()、/{record}/edit） | ○ |
| C-14 | 画面遷移（一覧/詳細から） | E-04（画面遷移図） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の画面で編集動作を確認
- [ ] デフォルト会社の削除ボタン非表示を確認
