---
generated_at: 2025-12-26 19:08:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：325-会社詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/security/src/Filament/Resources/CompanyResource/Pages/ViewCompany.php`
- E-02: `plugins/webkul/security/src/Filament/Resources/CompanyResource.php`
- E-03: `plugins/webkul/support/src/Models/Company.php`
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が詳細表示 | E-01（ViewRecordを継承） | ○ |
| C-02 | 編集ボタン | E-01（EditAction::make()） | ○ |
| C-03 | 削除ボタン | E-01（DeleteAction::make()） | ○ |
| C-04 | デフォルト会社判定で削除非表示 | E-01（hidden条件） | ○ |
| C-05 | 削除成功通知 | E-01（successNotification()） | ○ |
| C-06 | Infolist定義 | E-02（infolist()メソッド） | ○ |
| C-07 | 3カラムレイアウト | E-02（Grid::make(['default' => 3])） | ○ |
| C-08 | 会社情報セクション | E-02（Section::make、company-information） | ○ |
| C-09 | 住所情報セクション | E-02（Section::make、address-information） | ○ |
| C-10 | 追加情報セクション | E-02（Section::make、additional-information） | ○ |
| C-11 | ブランディングセクション | E-02（Section::make、branding） | ○ |
| C-12 | 連絡先情報セクション | E-02（Section::make、contact-information） | ○ |
| C-13 | メールコピー機能 | E-02（copyable(), copyMessage(), copyMessageDuration()） | ○ |
| C-14 | BranchesRelationManager | E-02（getRelations()） | ○ |
| C-15 | ルーティング定義 | E-02（getPages()、/{record}） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の画面で表示内容を確認
- [ ] メールコピー機能の動作を確認
- [ ] 支社リレーション管理機能を確認
