---
generated_at: 2025-12-26 18:10:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：33-支払条件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **削除制約違反時のメッセージ**：エラーハンドリングの実装詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource/Pages/ListPaymentTerms.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource.php`
- E-03: `plugins/webkul/accounts/src/Models/PaymentTerm.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「支払条件一覧」 | E-04 | ○ |
| C-02 | URLパターンは `/payment-terms` | E-02 (getPages) | ○ |
| C-03 | ListRecordsを継承 | E-01 | ○ |
| C-04 | ヘッダーにCreateActionがある | E-01 (getHeaderActions) | ○ |
| C-05 | 新規作成ボタンにplus-circleアイコン | E-01 (icon) | ○ |
| C-06 | 「すべて」と「アーカイブ済み」のタブがある | E-01 (getTabs) | ○ |
| C-07 | タブバッジにレコード数表示 | E-01 (badge) | ○ |
| C-08 | アーカイブ済みタブはonlyTrashedで取得 | E-01 (modifyQueryUsing) | ○ |
| C-09 | nameカラムが検索・ソート可能 | E-02 (table) | ○ |
| C-10 | company.nameカラムが検索・ソート可能 | E-02 (table) | ○ |
| C-11 | created_at/updated_atはデフォルト非表示 | E-02 (toggleable) | ○ |
| C-12 | 複数のグループ化オプションがある | E-02 (groups) | ○ |
| C-13 | ViewAction, EditAction, DeleteActionがある | E-02 (recordActions) | ○ |
| C-14 | RestoreAction, ForceDeleteActionがある | E-02 (recordActions) | ○ |
| C-15 | 削除時に成功通知を表示 | E-02 (successNotification) | ○ |
| C-16 | 復元時に成功通知を表示 | E-02 (successNotification) | ○ |
| C-17 | 完全削除時に成功通知を表示 | E-02 (successNotification) | ○ |
| C-18 | BulkActionGroupがある | E-02 (toolbarActions) | ○ |
| C-19 | DeleteBulkAction, RestoreBulkAction, ForceDeleteBulkActionがある | E-02 (toolbarActions) | ○ |
| C-20 | SoftDeletesトレイトを使用 | E-03 (use SoftDeletes) | ○ |
| C-21 | テーブル名はaccounts_payment_terms | E-03 ($table) | ○ |
| C-22 | グループはcollapsible | E-02 (groups) | ○ |
| C-23 | 各グループ化オプションの項目 | E-02 (groups) | ○ |
| C-24 | 多言語通知メッセージを使用 | E-02 (言語キー使用) | ○ |
| C-25 | 日時カラムはdateTime形式で表示 | E-02 (dateTime) | ○ |
| C-26 | 削除制約違反時にエラー通知 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 削除時の外部キー制約違反ハンドリング
  - 候補：`DeleteAction`のカスタムエラーハンドラ / DBマイグレーションの制約設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル構造と表示項目
- 0: 低リスク - タブ切り替えとフィルタリング
- 1: 中リスク - 削除時のエラーハンドリング

## 6) レビュアーチェックリスト（最小）
- [ ] 多言語ファイルの通知メッセージ内容を確認
- [ ] 支払条件が請求書等で使用中の場合の削除動作を確認
- [ ] グループ化機能が正しく動作するか実機確認
- [ ] ソフトデリート後の復元・完全削除が正しく動作するか確認
