---
generated_at: 2025-12-26 19:18:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：330-アクティビティタイプ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/support/src/Filament/Resources/ActivityTypeResource/Pages/ListActivityTypes.php`
- E-02: `plugins/webkul/support/src/Filament/Resources/ActivityTypeResource.php`
- E-03: `plugins/webkul/support/src/Models/ActivityType.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が一覧 | E-01（ListRecordsを継承） | ○ |
| C-02 | 全件/アーカイブのタブ切替 | E-01（getTabs()） | ○ |
| C-03 | 件数バッジ表示 | E-01（ActivityType::where(...)->count()） | ○ |
| C-04 | 新規作成ボタン | E-01（CreateAction::make()） | ○ |
| C-05 | プラグイン名でフィルタ | E-01（$pluginName = 'support'） | ○ |
| C-06 | テーブルカラム定義 | E-02（table()メソッド、columns配列） | ○ |
| C-07 | グループ化設定 | E-02（groups配列） | ○ |
| C-08 | フィルタ設定（アクション・ステータス・遅延） | E-02（filters配列） | ○ |
| C-09 | 行アクション（View/Edit/Delete/Restore/ForceDelete） | E-02（recordActions） | ○ |
| C-10 | 一括アクション | E-02（toolbarActions） | ○ |
| C-11 | 完全削除時のエラー処理 | E-02（try-catch QueryException） | ○ |
| C-12 | プラグインでクエリ修正 | E-02（modifyQueryUsing） | ○ |
| C-13 | 並び替え対応 | E-02（reorderable('sort')） | ○ |
| C-14 | カラム管理2列 | E-02（columnManagerColumns(2)） | ○ |
| C-15 | ナビゲーション非登録 | E-02（$shouldRegisterNavigation = false） | ○ |
| C-16 | ActivityTypeモデルのfillable | E-03（$fillable定義） | ○ |
| C-17 | SoftDeletes使用 | E-03（use SoftDeletes） | ○ |
| C-18 | Sortable使用 | E-03（use SortableTrait、implements Sortable） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の画面で一覧表示・フィルタ動作を確認
- [ ] 完全削除時の外部キー制約エラー処理を確認
- [ ] 各モジュールでのプラグイン名切り替え動作を確認
