---
generated_at: 2025-12-26 12:20:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：335-マイ休暇作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **URLパスの正確性**：クラスター構成から推定
  2. **メッセージ内容の実際の文言**：言語ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyTimeOffResource/Pages/CreateMyTimeOff.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyTimeOffResource.php`
- E-03: `plugins/webkul/time-off/src/Traits/TimeOffHelper.php`
- E-04: `plugins/webkul/time-off/src/Models/Leave.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はCreateRecordを継承 | E-01 (line 6-10) | ○ |
| C-02 | TimeOffHelperトレイトを使用 | E-01 (line 8, 12) | ○ |
| C-03 | 作成後は詳細画面へリダイレクト | E-01 (line 25-27) | ○ |
| C-04 | 作成成功時に通知を表示 | E-01 (line 30-35) | ○ |
| C-05 | mutateFormDataBeforeCreateでデータ加工 | E-01 (line 38-41) | ○ |
| C-06 | サブナビゲーションが表示される | E-01 (line 14-20) | ○ |
| C-07 | フォーム定義はgetFormSchemaメソッド | E-02 (line 45-47), E-03 (line 44-182) | ○ |
| C-08 | holiday_status_idフィールドがある | E-03 (line 76-82) | ○ |
| C-09 | request_date_fromフィールドがある | E-03 (line 86-100) | ○ |
| C-10 | request_date_toフィールドがある | E-03 (line 102-115) | ○ |
| C-11 | request_unit_halfトグルがある | E-03 (line 120-130) | ○ |
| C-12 | request_date_from_periodフィールドがある | E-03 (line 132-139) | ○ |
| C-13 | private_nameフィールドがある | E-03 (line 174-179) | ○ |
| C-14 | duration_info表示がある | E-03 (line 142-172) | ○ |
| C-15 | 半日休暇時は0.5 dayと表示 | E-03 (line 146-147) | ○ |
| C-16 | 営業日計算がある | E-03 (line 343-355, 420-428) | ○ |
| C-17 | 重複チェックがある | E-03 (line 225-264, 368-388) | ○ |
| C-18 | 休暇残日数チェックがある | E-03 (line 271-337) | ○ |
| C-19 | stateはconfirmで登録 | E-03 (line 37) | ○ |
| C-20 | 従業員情報が必要 | E-03 (line 227-242) | ○ |
| C-21 | カレンダーIDが設定される | E-03 (line 453-456) | ○ |
| C-22 | creator_idが設定される | E-03 (line 36) | ○ |
| C-23 | 半日休暇時は終了日フィールドが非表示 | E-03 (line 105) | ○ |
| C-24 | 半日休暇時は期間選択が表示 | E-03 (line 137) | ○ |
| C-25 | 終了日の最小日付は開始日 | E-03 (line 110) | ○ |
| C-26 | 終了日は開始日が未選択時は無効 | E-03 (line 109) | ○ |
| C-27 | 重複時はエラー通知 | E-03 (line 252-263) | ○ |
| C-28 | 割当なし時はエラー通知 | E-03 (line 309-319) | ○ |
| C-29 | 残日数不足時はエラー通知 | E-03 (line 322-336) | ○ |
| C-30 | 従業員未登録時はエラー通知 | E-03 (line 229-241) | ○ |
| C-31 | 部署IDは従業員から取得 | E-03 (line 446-451) | ○ |
| C-32 | 会社IDはログインユーザーから取得 | E-03 (line 460-462) | ○ |
| C-33 | Leaveモデルを使用 | E-02 (line 27), E-04 | ○ |
| C-34 | URLパスの正確性 | **根拠なし** | △ |
| C-35 | メッセージ内容の具体的な文言 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 正確なURLパスはルーティング設定を確認する必要がある
  - 候補：`routes/web.php` / Filamentのルーティング設定
- 言語ファイル（notification.title, notification.body等）の実際の内容
  - 候補：`lang/ja/time-off.php` / `resources/lang/`ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム項目の設定内容（コードから正確に読み取り可能）
- 0: 低リスク - バリデーション処理（コードから確認済み）
- 1: 中リスク - URLパス（クラスター構成から推定）
- 0: 低リスク - データベース更新処理（TimeOffHelperから確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のURLパスを確認
- [ ] 言語ファイルの通知メッセージを確認
- [ ] 重複チェックの動作確認
- [ ] 休暇残日数チェックの動作確認
- [ ] 半日休暇トグル時の動的表示を確認
- [ ] 期間自動計算の動作確認
